/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xwiki.confluencepro.referencefixer;

/**
 * Type of broken links.
 * @since 1.29.0
 * @version $Id$
 */
public enum BrokenRefType
{
    /**
     * References to fix are broken links of the shape spaceName.name-strategy-validated-page-title.
     * These references were generated by old versions of the migrator.
     */
    BROKEN_LINKS,

    /**
     * References to fix are confluence references (confluencePage, confluenceAttach, confluenceSpace).
     * These references are generated by current versions of the migrator.
     */
    CONFLUENCE_REFS,

    /**
     * References to fix are of unknown shape and all kinds of references should be fixed.
     */
    UNKNOWN
}
