/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.referencefixer.script;

import com.xpn.xwiki.api.Document;
import com.xwiki.confluencepro.referencefixer.BrokenRefType;
import com.xwiki.confluencepro.referencefixer.internal.ReferenceFixingJobRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="confluencepro.referencefixer")
@Singleton
public class ConfluenceReferenceFixerScriptService
implements ScriptService {
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceResolver<String> resolver;

    public Job createAndRunReferenceFixingJob(Document statusDocument) {
        if (!this.authorization.hasAccess(Right.ADMIN)) {
            return null;
        }
        List<EntityReference> migrationReferences = this.getMigrations(statusDocument);
        List<EntityReference> spaceReferences = this.getSpaces(statusDocument);
        BrokenRefType brokenRefType = ConfluenceReferenceFixerScriptService.getBrokenRefType(statusDocument);
        String[] baseURLs = ConfluenceReferenceFixerScriptService.getBaseURLs(statusDocument);
        boolean exhaustive = ConfluenceReferenceFixerScriptService.isTrue(statusDocument, "exhaustive");
        boolean updateInPlace = ConfluenceReferenceFixerScriptService.isTrue(statusDocument, "updateInPlace");
        boolean dryRun = ConfluenceReferenceFixerScriptService.isTrue(statusDocument, "dryRun");
        ReferenceFixingJobRequest jobRequest = new ReferenceFixingJobRequest(statusDocument.getDocumentReference(), migrationReferences, spaceReferences, baseURLs, brokenRefType, exhaustive, updateInPlace, dryRun);
        try {
            return this.jobExecutor.execute("confluence.referencefixing", (Request)jobRequest);
        }
        catch (JobException e) {
            this.logger.error("Failed to execute the migration job for [{}].", (Object)statusDocument, (Object)e);
            return null;
        }
    }

    private static boolean isTrue(Document statusDocument, String fieldName) {
        Object value = statusDocument.getValue(fieldName);
        if (value == null) {
            return false;
        }
        return value.equals(1);
    }

    private static String[] getBaseURLs(Document statusDocument) {
        List baseURLs = (List)statusDocument.getValue("baseURLs");
        if (baseURLs == null) {
            return new String[0];
        }
        return (String[])baseURLs.toArray(String[]::new);
    }

    private static BrokenRefType getBrokenRefType(Document statusDocument) {
        BrokenRefType brokenRefType = BrokenRefType.UNKNOWN;
        String brokenRefTypeStr = (String)statusDocument.getValue("brokenRefType");
        if (StringUtils.isNotEmpty((CharSequence)brokenRefTypeStr)) {
            try {
                brokenRefType = BrokenRefType.valueOf(brokenRefTypeStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return brokenRefType;
    }

    private List<EntityReference> getSpaces(Document statusDocument) {
        List<EntityReference> spaceReferences = Collections.emptyList();
        List spaces = (List)statusDocument.getValue("spaces");
        if (CollectionUtils.isNotEmpty((Collection)spaces)) {
            spaceReferences = new ArrayList<EntityReference>(spaces.size());
            for (String space : spaces) {
                if (!StringUtils.isNotEmpty((CharSequence)space)) continue;
                EntityType spaceType = space.endsWith(".WebHome") ? EntityType.DOCUMENT : EntityType.SPACE;
                EntityReference spaceReference = this.resolver.resolve((Object)space, spaceType, new Object[0]);
                if (spaceReference.getType() == EntityType.DOCUMENT) {
                    spaceReference = spaceReference.getParent();
                }
                spaceReferences.add(spaceReference);
            }
        }
        return spaceReferences;
    }

    private List<EntityReference> getMigrations(Document statusDocument) {
        List<EntityReference> migrationReferences = Collections.emptyList();
        List migrations = (List)statusDocument.getValue("migrations");
        if (CollectionUtils.isNotEmpty((Collection)migrations)) {
            for (String migration : migrations) {
                migrationReferences = new ArrayList<EntityReference>(migrations.size());
                if (!StringUtils.isNotEmpty((CharSequence)migration)) continue;
                migrationReferences.add(this.resolver.resolve((Object)migration, EntityType.DOCUMENT, new Object[0]));
            }
        }
        return migrationReferences;
    }

    public List<String> getReferenceFixingJobId(EntityReference statusDocument) {
        return ReferenceFixingJobRequest.getJobId(statusDocument);
    }
}

