/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.referencefixer.internal;

import com.xwiki.confluencepro.internal.MigrationFixingStats;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class Stats
implements MigrationFixingStats {
    private long failedDocs;
    private long failedRefs;
    private long successfulRefs;
    private long successfulDocs;
    private long unchangedDocs;
    private Map<String, Integer> failedReferences = new HashMap<String, Integer>();

    Stats() {
    }

    public String toJSON() {
        return "{\"successfulDocs\": " + this.successfulDocs + ",\"unchangedDocs\": " + this.unchangedDocs + ",\"failedDocs\": " + this.failedDocs + ",\"successfulRefs\": " + this.successfulRefs + ",\"failedRefs\": " + this.failedRefs + "}";
    }

    String getFailedReferencesTSV() {
        return this.failedReferences.entrySet().stream().map(e -> (String)e.getKey() + "\t" + String.valueOf(e.getValue())).collect(Collectors.joining("\n"));
    }

    public void incFailedDocs() {
        ++this.failedDocs;
    }

    void addFailedRef(String reference) {
        int count = this.failedReferences.getOrDefault(reference, 0);
        this.failedReferences.put(reference, count + 1);
        ++this.failedRefs;
    }

    public void incSuccessfulDocs() {
        ++this.successfulDocs;
    }

    public void incUnchangedDocs() {
        ++this.unchangedDocs;
    }

    void incSuccessfulRefs() {
        ++this.successfulRefs;
    }

    void incSuccessfulRefs(long c) {
        this.successfulRefs += c;
    }
}

