/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.referencefixer.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.confluencepro.internal.MigrationFixingStats;
import com.xwiki.confluencepro.internal.MigrationFixingTools;
import com.xwiki.confluencepro.referencefixer.BrokenRefType;
import com.xwiki.confluencepro.referencefixer.internal.Stats;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.contrib.confluence.resolvers.ConfluencePageTitleResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceResolverException;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceKeyResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceResolver;
import org.xwiki.contrib.confluence.resolvers.resource.ConfluenceResourceReferenceResolver;
import org.xwiki.contrib.confluence.resolvers.resource.ConfluenceResourceReferenceType;
import org.xwiki.contrib.confluence.urlmapping.ConfluenceURLMapper;
import org.xwiki.contrib.urlmapping.DefaultURLMappingMatch;
import org.xwiki.contrib.urlmapping.URLMappingMatch;
import org.xwiki.contrib.urlmapping.URLMappingResult;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.OrBlockMatcher;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.ResourceReferenceTypeParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.entity.EntityResourceReference;

@Component(roles={ConfluenceReferenceFixer.class})
@Singleton
public class ConfluenceReferenceFixer {
    private static final String DOCUMENT = "document";
    private static final Pattern BROKEN_LINK_PATTERN = Pattern.compile("(?<space>[a-zA-Z0-9_~-]+)\\.(?<nameValidatedTitle>[\\s\\S]+?)(?:(?<!\\\\)@(?<attachment>[\\s\\S]+))?");
    private static final TypeReference<Map<String, List<Map<String, Object>>>> CONFLUENCE_REF_WARNINGS_TYPE_REF = new TypeReference<Map<String, List<Map<String, Object>>>>(){};
    private static final TypeReference<Map<String, Object>> CONFLUENCE_BROKEN_LINK_PAGES_REF = new TypeReference<Map<String, Object>>(){};
    private static final String WEB_HOME = "WebHome";
    private static final Marker FAILED_REFERENCE_CONVERSION_MARKER = MarkerFactory.getMarker((String)"confluencereferencefixer.failedrefconversion");
    private static final Marker SUCCESSFUL_REFERENCE_CONVERSION_MARKER = MarkerFactory.getMarker((String)"confluencereferencefixer.successfulrefconversion");
    private static final Marker CHANGED_AT_PARSE_TIME_MARKER = MarkerFactory.getMarker((String)"confluencereferencefixer.changedatparsetime");
    private static final String UPDATE_PARAM_LOG = "Document [{}]: Updating macro [{}]'s parameter [{}]: [{}] -> [{}]";
    private static final String CONFLUENCE = "confluence";
    private static final String EXCEPTION_WHILE_RESOLVING = "Document [{}]: Failed to resolve [{}] because of an exception";
    private static final List<String> ALLOWED_BROKEN_LINK_MACROS = List.of("include", "display", "locationsearch", "children", "confluence_children");
    private static final String SELF = "@self";
    private static final String ATTACH = "attach:";
    private static final String DOCUMENT_COL = "document:";
    private static final String COMMENT = "comment";
    private static final String SLASH = "/";
    private static final String BROKEN_LINKS_PAGES_JSON = "brokenLinksPages.json";
    private static final String CONFLUENCE_REF_WARNINGS_JSON = "confluenceRefWarnings.json";
    private static final String BROKEN_LINKS_PAGES = "brokenLinksPages";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ConfluencePageTitleResolver pageTitleResolver;
    @Inject
    private ConfluenceSpaceKeyResolver spaceKeyResolver;
    @Inject
    private ConfluenceSpaceResolver spaceResolver;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private ConfluenceResourceReferenceResolver confluenceResourceReferenceResolver;
    @Inject
    private MigrationFixingTools migrationFixingTools;

    public Stats fixDocuments(List<EntityReference> migrationReferences, List<EntityReference> spaceReferences, String[] baseURLs, BrokenRefType brokenRefType, boolean exhaustive, boolean updateInPlace, boolean dryRun) {
        this.logConfluenceReferenceParserPresence();
        BrokenRefType b = brokenRefType == null ? BrokenRefType.UNKNOWN : brokenRefType;
        Stats s = new Stats();
        String[] baseURLsNotNull = baseURLs == null ? new String[]{} : baseURLs;
        this.migrationFixingTools.fixDocuments((MigrationFixingStats)s, migrationReferences, spaceReferences, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, baseURLsNotNull, updateInPlace, b, dryRun), migrationDoc -> this.fixDocumentsOfMigration(s, (XWikiDocument)migrationDoc, baseURLs, exhaustive, updateInPlace, dryRun));
        return s;
    }

    private void fixDocumentsOfMigration(Stats s, XWikiDocument migrationDoc, String[] baseURLs, boolean exhaustive, boolean updateInPlace, boolean dryRun) {
        String[] actualBaseURLs = baseURLs == null || baseURLs.length == 0 ? this.getBaseURLs(migrationDoc, this.migrationFixingTools.getInputProperties(migrationDoc)) : baseURLs;
        boolean foundShortcut = false;
        if (!exhaustive && !(foundShortcut = this.fixDocumentsListedInRefWarnings(s, migrationDoc, actualBaseURLs, updateInPlace, dryRun))) {
            foundShortcut = this.fixDocumentsListedInBrokenLinks(s, migrationDoc, actualBaseURLs, updateInPlace, dryRun);
        }
        if (!foundShortcut) {
            if (!exhaustive) {
                this.logger.warn("Failed to find a strategy to find only affected documents, will browse all the documents");
            }
            BrokenRefType b = ConfluenceReferenceFixer.getBrokenRefType(migrationDoc);
            this.migrationFixingTools.fixDocumentsOfMigration(migrationDoc, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, actualBaseURLs, updateInPlace, b, dryRun));
        }
    }

    private static BrokenRefType getBrokenRefType(XWikiDocument migrationDoc) {
        if (migrationDoc.getAttachment(CONFLUENCE_REF_WARNINGS_JSON) != null) {
            return BrokenRefType.CONFLUENCE_REFS;
        }
        if (migrationDoc.getAttachment(BROKEN_LINKS_PAGES_JSON) != null || StringUtils.isNotEmpty((CharSequence)migrationDoc.getStringValue(BROKEN_LINKS_PAGES))) {
            return BrokenRefType.BROKEN_LINKS;
        }
        return BrokenRefType.UNKNOWN;
    }

    private boolean fixDocumentsListedInRefWarnings(Stats s, XWikiDocument migrationDoc, String[] baseURLs, boolean updateInPlace, boolean dryRun) {
        Map refWarnings;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiAttachment refWarningsAttachment = migrationDoc.getAttachment(CONFLUENCE_REF_WARNINGS_JSON);
        if (refWarningsAttachment == null) {
            return false;
        }
        try {
            XWikiAttachmentContent attachmentContent = refWarningsAttachment.getAttachmentContent(context);
            InputStream contentInputStream = attachmentContent.getContentInputStream();
            refWarnings = (Map)new ObjectMapper().readValue(contentInputStream, CONFLUENCE_REF_WARNINGS_TYPE_REF);
        }
        catch (XWikiException | IOException e) {
            this.logger.error("Failed to get the list of broken references", e);
            return false;
        }
        Collection docRefs = refWarnings.entrySet().stream().filter(warningListEntries -> {
            List warningList = (List)warningListEntries.getValue();
            return warningList.stream().anyMatch(warning -> {
                Object originalVersion = warning.get("originalVersion");
                return originalVersion == null || originalVersion.equals(warning.get("pageId"));
            });
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        this.migrationFixingTools.fixDocuments(docRefs, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, baseURLs, updateInPlace, BrokenRefType.CONFLUENCE_REFS, dryRun));
        return true;
    }

    private boolean fixDocumentsListedInBrokenLinks(Stats s, XWikiDocument migrationDoc, String[] baseURLs, boolean updateInPlace, boolean dryRun) {
        Map brokenLinksPages;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiAttachment brokenLinksPageAttachment = migrationDoc.getAttachment(BROKEN_LINKS_PAGES_JSON);
        try {
            if (brokenLinksPageAttachment == null) {
                String brokenLinksPageJSON = migrationDoc.getStringValue(BROKEN_LINKS_PAGES);
                if (StringUtils.isEmpty((CharSequence)brokenLinksPageJSON)) {
                    return false;
                }
                brokenLinksPages = (Map)new ObjectMapper().readValue(brokenLinksPageJSON, CONFLUENCE_BROKEN_LINK_PAGES_REF);
            } else {
                XWikiAttachmentContent attachmentContent = brokenLinksPageAttachment.getAttachmentContent(context);
                InputStream contentInputStream = attachmentContent.getContentInputStream();
                brokenLinksPages = (Map)new ObjectMapper().readValue(contentInputStream, CONFLUENCE_BROKEN_LINK_PAGES_REF);
            }
        }
        catch (XWikiException | IOException e) {
            this.logger.error("Failed to get the list of affected pages affected by broken links", e);
            return false;
        }
        Set docRefs = brokenLinksPages.keySet();
        this.migrationFixingTools.fixDocuments(docRefs, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, baseURLs, updateInPlace, BrokenRefType.BROKEN_LINKS, dryRun));
        return true;
    }

    private String[] getBaseURLs(XWikiDocument migrationDoc, Map<String, Object> props) {
        if (props == null) {
            this.logger.warn("Missing input properties means we could not find base URLs for migration [{}]", (Object)migrationDoc.getDocumentReference());
            return new String[0];
        }
        Object baseURLsString = props.get("baseURLs");
        if (baseURLsString instanceof String && !StringUtils.isEmpty((CharSequence)((String)baseURLsString))) {
            return (String[])Arrays.stream(((String)baseURLsString).split(",")).map(baseURL -> StringUtils.removeEnd((String)baseURL, (String)SLASH)).toArray(String[]::new);
        }
        this.logger.warn("Base URLs are not set for migration [{}], will not use them", (Object)migrationDoc.getDocumentReference());
        return new String[0];
    }

    private void logConfluenceReferenceParserPresence() {
        boolean present;
        try {
            present = this.componentManager.getInstance(ResourceReferenceTypeParser.class, "confluencePage") != null;
        }
        catch (ComponentLookupException ignored) {
            present = false;
        }
        if (present) {
            this.logger.info("Confluence resource reference type parsers are present. This means that some Confluence references may be automatically and silently fixed at parse time and not while analysing the document content, and these fixes will not be logged.");
        } else {
            this.logger.info("Confluence resource reference type parsers are not present. No fix will be done at parse time, all fixes will be done while analysing the document content. Reference fix logging should be detailed.");
        }
    }

    private void fixDocument(Stats s, XWikiDocument migratedDoc, String[] baseURLs, boolean updateInPlace, BrokenRefType brokenRefType, boolean dryRun) {
        DocumentReference migratedDocRef = migratedDoc.getDocumentReference();
        try {
            String oldContent = migratedDoc.getContent();
            XDOM xdom = migratedDoc.getXDOM();
            String syntax = migratedDoc.getSyntax().toIdString();
            String[] baseURLsNotNull = baseURLs == null ? new String[]{} : baseURLs;
            boolean updated = this.visitXDOMToFixRefs(s, xdom, syntax, (EntityReference)migratedDocRef, baseURLsNotNull, brokenRefType);
            updated = this.updateComments(s, migratedDoc, syntax, (EntityReference)migratedDocRef, baseURLsNotNull, brokenRefType) || updated;
            updated = this.updateGliffyDiagrams(s, migratedDoc, (EntityReference)migratedDocRef, baseURLsNotNull) || updated;
            this.maybeUpdateDocument(s, migratedDoc, xdom, oldContent, updateInPlace, updated, dryRun);
        }
        catch (Exception e) {
            this.logger.error("Failed to fix document [{}]", (Object)migratedDocRef, (Object)e);
        }
    }

    private boolean convertGliffyDiagramNode(Stats s, JsonNode jsonNode, EntityReference migratedDocRef, String[] baseURLsNotNull) {
        if (jsonNode.isArray()) {
            boolean updated = false;
            for (JsonNode node : jsonNode) {
                updated = this.convertGliffyDiagramNode(s, node, migratedDocRef, baseURLsNotNull) || updated;
            }
            return updated;
        }
        if (jsonNode.isObject()) {
            return this.convertGliffyDiagramObject(s, jsonNode, migratedDocRef, baseURLsNotNull);
        }
        return false;
    }

    private boolean convertGliffyDiagramObject(Stats s, JsonNode jsonNode, EntityReference migratedDocRef, String[] baseURLsNotNull) {
        boolean updated = false;
        List fieldsCopy = IteratorUtils.toList((Iterator)jsonNode.fields());
        for (Map.Entry field : fieldsCopy) {
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            if ("url".equals(key) || "href".equals(key) && value.isValueNode() && value.isTextual()) {
                org.xwiki.rendering.listener.reference.ResourceReference resourceReference;
                String url = value.asText();
                if (StringUtils.startsWith((CharSequence)url, (CharSequence)"data:") || (resourceReference = this.maybeConvertURLAsResourceRef(s, url, migratedDocRef, baseURLsNotNull, true)) == null || resourceReference.getType() != ResourceType.URL) continue;
                ((ObjectNode)jsonNode).put(key, resourceReference.getReference());
                updated = true;
                continue;
            }
            updated = this.convertGliffyDiagramNode(s, value, migratedDocRef, baseURLsNotNull) || updated;
        }
        return updated;
    }

    private boolean updateGliffyDiagrams(Stats s, XWikiDocument migratedDoc, EntityReference migratedDocRef, String[] baseURLsNotNull) throws XWikiException {
        boolean updated = false;
        for (XWikiAttachment a : migratedDoc.getAttachmentList()) {
            String filename = a.getFilename();
            if (migratedDoc.getAttachment(filename + ".png") == null) continue;
            updated = this.convertGliffyDiagram(s, migratedDocRef, baseURLsNotNull, a, filename) || updated;
        }
        return updated;
    }

    private boolean convertGliffyDiagram(Stats s, EntityReference migratedDocRef, String[] baseURLsNotNull, XWikiAttachment a, String filename) throws XWikiException {
        JsonNode jsonRoot;
        XWikiAttachmentContent attachmentContent = a.getAttachmentContent((XWikiContext)this.contextProvider.get());
        if (attachmentContent == null) {
            this.logger.error("Document [{}]: could not convert Gliffy diagram: Content of attachment [{}] is null", (Object)migratedDocRef, (Object)filename);
            return false;
        }
        try {
            jsonRoot = new ObjectMapper().readTree(attachmentContent.getContentInputStream());
        }
        catch (IOException e) {
            this.logger.warn("Document [{}]: could not convert Gliffy diagram: Could not parse JSON of attachment [{}]. Maybe this is not a Gliffy diagram after all", new Object[]{migratedDocRef, filename, e});
            return false;
        }
        if (this.convertGliffyDiagramNode(s, jsonRoot, migratedDocRef, baseURLsNotNull)) {
            try {
                attachmentContent.setContent((InputStream)new ByteArrayInputStream(new ObjectMapper().writeValueAsBytes((Object)jsonRoot)));
            }
            catch (IOException e) {
                this.logger.error("Document [{}]: could not update the Gliffy diagram (attachment [{}])", new Object[]{migratedDocRef, filename, e});
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean updateComments(Stats s, XWikiDocument migratedDoc, String syntaxId, EntityReference migratedDocRef, String[] baseURLsNotNull, BrokenRefType brokenRefType) {
        boolean updated = false;
        for (BaseObject comment : migratedDoc.getComments()) {
            String content = comment.getLargeStringValue(COMMENT);
            XDOM xdom = this.getCommentXDOM(syntaxId, content);
            if (xdom == null) continue;
            boolean commentUpdated = this.hasXDOMChangedAtParseTime(s, migratedDocRef, content, this.render((Block)xdom, syntaxId), true);
            boolean bl = commentUpdated = commentUpdated || this.visitXDOMToFixRefs(s, xdom, syntaxId, migratedDocRef, baseURLsNotNull, brokenRefType);
            if (commentUpdated) {
                String newContent = this.render((Block)xdom, syntaxId);
                comment.setLargeStringValue(COMMENT, newContent);
            }
            updated = updated || commentUpdated;
        }
        return updated;
    }

    private XDOM getCommentXDOM(String syntaxId, String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        XDOM xdom = this.parse(content, syntaxId);
        if (xdom == null) {
            this.logger.warn("Failed to parse comment content, skipping.");
            return null;
        }
        return xdom;
    }

    private void maybeUpdateDocument(Stats s, XWikiDocument migratedDoc, XDOM xdom, String oldContent, boolean updateInPlace, boolean updated, boolean dryRun) {
        Syntax origSyntax = migratedDoc.getSyntax();
        boolean upd = updated;
        DocumentReference migratedDocRef = migratedDoc.getDocumentReference();
        try {
            String syntax = origSyntax.toIdString();
            if (syntax.contains(CONFLUENCE)) {
                this.logger.warn("Document [{}] uses syntax [{}] and will be converted to [{}]. The report about references being updated at parse time would be inaccurate", new Object[]{migratedDocRef, syntax, Syntax.XWIKI_2_1});
                migratedDoc.setSyntax(Syntax.XWIKI_2_1);
                upd = true;
            }
            migratedDoc.setContent(xdom);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to update the document XDOM [{}]", (Object)migratedDocRef, (Object)e);
            s.incFailedDocs();
            return;
        }
        String newContent = migratedDoc.getContent();
        upd = this.hasXDOMChangedAtParseTime(s, (EntityReference)migratedDocRef, oldContent, newContent, false) || upd;
        this.migrationFixingTools.handleDocumentUpdate((MigrationFixingStats)s, migratedDoc, upd, updateInPlace, dryRun, "Fix broken links");
    }

    private boolean hasXDOMChangedAtParseTime(Stats s, EntityReference migratedDocRef, String oldContent, String newContent, boolean inAComment) {
        int newConfluenceOccurrences;
        int oldConfluenceOccurences = StringUtils.countMatches((CharSequence)oldContent, (CharSequence)CONFLUENCE);
        int diff = oldConfluenceOccurences - (newConfluenceOccurrences = StringUtils.countMatches((CharSequence)newContent, (CharSequence)CONFLUENCE));
        if (diff > 0) {
            if (inAComment) {
                this.logger.info(CHANGED_AT_PARSE_TIME_MARKER, "Document [{}] has changed at parse time ([{}] references updated) in a comment", (Object)migratedDocRef, (Object)diff);
            } else {
                this.logger.info(CHANGED_AT_PARSE_TIME_MARKER, "Document [{}] has changed at parse time ([{}] references updated)", (Object)migratedDocRef, (Object)diff);
            }
            s.incSuccessfulRefs(diff);
            return true;
        }
        return false;
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertURLAsResourceRef(Stats s, String maybeURL, EntityReference migratedDocRef, String[] baseURLs, boolean asURL) {
        List<ConfluenceURLMapper> mappers = this.getConfluenceURLMappers(s, maybeURL, migratedDocRef);
        if (StringUtils.isEmpty((CharSequence)maybeURL) || mappers == null) {
            return null;
        }
        if (maybeURL.startsWith("/x/")) {
            String urlWithoutExtraSlashes = maybeURL.replaceAll("/+", SLASH);
            return this.maybeConvertURLAsResourceRef(s, urlWithoutExtraSlashes, migratedDocRef, "", mappers, asURL);
        }
        if (baseURLs.length == 0) {
            return null;
        }
        try {
            for (String baseURL : baseURLs) {
                if (!maybeURL.startsWith(baseURL)) continue;
                return this.maybeConvertURLAsResourceRef(s, maybeURL, migratedDocRef, baseURL, mappers, asURL);
            }
        }
        catch (Exception e) {
            this.logger.error(FAILED_REFERENCE_CONVERSION_MARKER, "Document [{}]: Failed to convert Confluence URL [{}] because of an exception", new Object[]{migratedDocRef, maybeURL, e});
        }
        return null;
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertURLAsResourceRef(Stats s, String maybeURL, EntityReference migratedDocRef, String baseURL, List<ConfluenceURLMapper> mappers, boolean asURL) {
        org.xwiki.rendering.listener.reference.ResourceReference serializedEntity;
        String url = StringUtils.removeStart((String)maybeURL, (String)baseURL).replaceAll("^/+", "");
        String anchor = null;
        int anchorPos = url.indexOf(35);
        if (anchorPos != -1) {
            anchor = url.substring(anchorPos + 1);
            url = url.substring(0, anchorPos);
        }
        if ((serializedEntity = this.maybeConvertURLAsResourceRef(url, migratedDocRef, mappers, asURL)) == null) {
            this.logger.warn(FAILED_REFERENCE_CONVERSION_MARKER, "Document [{}]: Failed to convert Confluence URL [{}]", (Object)migratedDocRef, (Object)maybeURL);
            s.addFailedRef(maybeURL);
            return null;
        }
        if (anchor != null && serializedEntity instanceof DocumentResourceReference) {
            ((DocumentResourceReference)serializedEntity).setAnchor(anchor);
        }
        this.logger.info("Document [{}]: Converting URL [{}] to [{}]", new Object[]{migratedDocRef, maybeURL, serializedEntity});
        s.incSuccessfulRefs();
        return serializedEntity;
    }

    private List<ConfluenceURLMapper> getConfluenceURLMappers(Stats s, String maybeURL, EntityReference migratedDocRef) {
        List mappers = null;
        try {
            mappers = this.componentManager.getInstanceList(ConfluenceURLMapper.class);
        }
        catch (ComponentLookupException e) {
            this.logger.error(EXCEPTION_WHILE_RESOLVING, new Object[]{migratedDocRef, maybeURL, e});
            s.addFailedRef(maybeURL);
        }
        return mappers;
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertURLAsResourceRef(String url, EntityReference migratedDocRef, List<ConfluenceURLMapper> mappers, boolean asURL) {
        for (ConfluenceURLMapper mapper : mappers) {
            org.xwiki.rendering.listener.reference.ResourceReference serializedEntity;
            Pattern p;
            Matcher m = null;
            boolean notFound = false;
            Pattern[] patternArray = mapper.getSpecification().getRegexes();
            int n = patternArray.length;
            for (int i = 0; i < n && !(m = (p = patternArray[i]).matcher(url)).matches(); ++i) {
                notFound = true;
            }
            if (notFound || (serializedEntity = this.convertConvertURLAsResourceRef(url, migratedDocRef, mapper, m, asURL)) == null) continue;
            return serializedEntity;
        }
        return null;
    }

    private org.xwiki.rendering.listener.reference.ResourceReference convertConvertURLAsResourceRef(String url, EntityReference ref, ConfluenceURLMapper mapper, Matcher m, boolean asURL) {
        URLMappingResult resultObj = mapper.convert((URLMappingMatch)new DefaultURLMappingMatch(url, "get", (MatchResult)m, null));
        ResourceReference resourceReference = null;
        if (resultObj != null) {
            if (resultObj instanceof URLMappingResult) {
                resourceReference = resultObj.getResourceReference();
            } else if (resultObj instanceof ResourceReference) {
                resourceReference = (ResourceReference)resultObj;
            }
        }
        if (resourceReference instanceof EntityResourceReference) {
            EntityResourceReference rr = (EntityResourceReference)resourceReference;
            if (asURL) {
                XWikiContext context = (XWikiContext)this.contextProvider.get();
                String convertedURL = context.getWiki().getURL(rr.getEntityReference(), context);
                return new org.xwiki.rendering.listener.reference.ResourceReference(convertedURL, ResourceType.URL);
            }
            String serializedEntity = (String)this.serializer.serialize(rr.getEntityReference(), new Object[]{ref});
            String type = rr.getEntityReference().getType().getLowerCase();
            if (DOCUMENT.equals(type)) {
                return new DocumentResourceReference(serializedEntity);
            }
            return new org.xwiki.rendering.listener.reference.ResourceReference(serializedEntity, new ResourceType(type));
        }
        return null;
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertUnprefixedBrokenLink(Stats s, String oldRef, EntityReference migratedDocRef, boolean isAttachment) {
        org.xwiki.rendering.listener.reference.ResourceReference rr;
        int dot = oldRef.indexOf(46);
        if (dot == -1) {
            return null;
        }
        Matcher m = BROKEN_LINK_PATTERN.matcher(oldRef);
        if (!m.matches()) {
            return null;
        }
        String nameValidatedTitle = m.group("nameValidatedTitle");
        String attachment = m.group("attachment");
        if (ConfluenceReferenceFixer.containsUnescapedChar(nameValidatedTitle, '.') || WEB_HOME.equals(nameValidatedTitle) || isAttachment && StringUtils.isEmpty((CharSequence)attachment)) {
            return null;
        }
        String space = m.group("space");
        EntityReference newRef = null;
        try {
            newRef = this.tryResolvingBrokenLinkDoc(nameValidatedTitle, space);
        }
        catch (ConfluenceResolverException e) {
            this.logger.error(EXCEPTION_WHILE_RESOLVING, new Object[]{migratedDocRef, oldRef, e});
        }
        if (newRef == null) {
            this.logger.warn(FAILED_REFERENCE_CONVERSION_MARKER, "Document [{}]: Failed to convert broken link [{}]", (Object)migratedDocRef, (Object)oldRef);
            s.addFailedRef(oldRef);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)attachment)) {
            rr = new org.xwiki.rendering.listener.reference.ResourceReference((String)this.serializer.serialize(newRef, new Object[]{migratedDocRef}), ResourceType.DOCUMENT);
        } else {
            newRef = new EntityReference(attachment, EntityType.ATTACHMENT, newRef);
            rr = new org.xwiki.rendering.listener.reference.ResourceReference((String)this.serializer.serialize(newRef, new Object[]{migratedDocRef}), ResourceType.ATTACHMENT);
        }
        this.logger.info(SUCCESSFUL_REFERENCE_CONVERSION_MARKER, "Document [{}]: Converting broken link [{}] to [{}]", new Object[]{migratedDocRef, oldRef, rr});
        s.incSuccessfulRefs();
        return rr;
    }

    private String maybeConvertBrokenLink(Stats s, String str, EntityReference ref) {
        String prefix;
        boolean attachment;
        int prefixLength = ConfluenceReferenceFixer.getReferencePrefixLength(str);
        String oldRef = str.substring(prefixLength);
        org.xwiki.rendering.listener.reference.ResourceReference newRef = this.maybeConvertUnprefixedBrokenLink(s, oldRef, ref, attachment = (prefix = str.substring(0, prefixLength)).equals(ATTACH));
        if (newRef == null) {
            return null;
        }
        return prefix + newRef.getReference();
    }

    private static boolean containsUnescapedChar(String str, char character) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != character) continue;
            return true;
        }
        return false;
    }

    private EntityReference tryResolvingBrokenLinkDoc(String nameValidatedTitle, String space) throws ConfluenceResolverException {
        if ("@home".equals(nameValidatedTitle)) {
            EntityReference spaceRef = this.spaceKeyResolver.getSpaceByKey(space);
            if (spaceRef == null) {
                return null;
            }
            return new EntityReference(WEB_HOME, EntityType.DOCUMENT, spaceRef);
        }
        return this.pageTitleResolver.getDocumentByTitle(space, nameValidatedTitle);
    }

    private String maybeConvertMacroParameter(Stats s, String str, EntityReference migratedDocRef, String[] baseURLs) {
        org.xwiki.rendering.listener.reference.ResourceReference rr = this.maybeConvertReference(s, str, migratedDocRef, baseURLs, BrokenRefType.CONFLUENCE_REFS, false);
        if (rr == null) {
            return null;
        }
        return rr.getReference();
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertReference(Stats s, org.xwiki.rendering.listener.reference.ResourceReference reference, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType) {
        if (reference == null) {
            return null;
        }
        ResourceType type = reference.getType();
        if (type.equals((Object)ResourceType.MAILTO) || type.equals((Object)ResourceType.DATA)) {
            return null;
        }
        if (type.equals((Object)ResourceType.URL)) {
            return this.maybeConvertURLAsResourceRef(s, reference.getReference(), migratedDocRef, baseURLs, false);
        }
        String scheme = type.getScheme();
        if (scheme.startsWith(CONFLUENCE)) {
            for (ConfluenceResourceReferenceType confluenceType : ConfluenceResourceReferenceType.values()) {
                String candidateType = confluenceType.getId();
                if (!candidateType.equals(scheme)) continue;
                return this.maybeConvertConfluenceReference(s, reference.getReference(), migratedDocRef, confluenceType);
            }
            this.logger.warn("Document [{}]: unrecognized Confluence resource reference type [{}] for reference [{}]", new Object[]{migratedDocRef, scheme, reference});
        }
        boolean attachment = type.equals((Object)ResourceType.ATTACHMENT);
        return this.maybeConvertReference(s, reference.getReference(), migratedDocRef, baseURLs, brokenRefType, attachment);
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertReference(Stats s, String reference, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType, boolean attachment) {
        String unprefixedRef;
        if (StringUtils.isEmpty((CharSequence)reference)) {
            return null;
        }
        if (reference.startsWith("url:")) {
            return this.maybeConvertURLAsResourceRef(s, reference.substring(4), migratedDocRef, baseURLs, false);
        }
        org.xwiki.rendering.listener.reference.ResourceReference res = this.maybeConvertURLAsResourceRef(s, reference, migratedDocRef, baseURLs, false);
        if (res != null) {
            return res;
        }
        if ((brokenRefType == BrokenRefType.BROKEN_LINKS || brokenRefType == BrokenRefType.UNKNOWN) && (res = this.maybeConvertUnprefixedBrokenLink(s, unprefixedRef = reference.substring(ConfluenceReferenceFixer.getReferencePrefixLength(reference)), migratedDocRef, attachment)) != null) {
            return res;
        }
        if (brokenRefType == BrokenRefType.CONFLUENCE_REFS || brokenRefType == BrokenRefType.UNKNOWN) {
            res = this.maybeConvertConfluenceReference(s, reference, migratedDocRef);
        }
        return res;
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertConfluenceReference(Stats s, String reference, EntityReference migratedDocRef) {
        ConfluenceResourceReferenceType type = this.confluenceResourceReferenceResolver.getType(reference);
        if (type == null) {
            return null;
        }
        String typelessReference = reference.substring(type.getId().length() + 1);
        return this.maybeConvertConfluenceReference(s, typelessReference, migratedDocRef, type);
    }

    private org.xwiki.rendering.listener.reference.ResourceReference maybeConvertConfluenceReference(Stats s, String reference, EntityReference migratedDocRef, ConfluenceResourceReferenceType type) {
        String ref = reference;
        try {
            org.xwiki.rendering.listener.reference.ResourceReference r;
            String space;
            if ((ref.startsWith("page:@self") || ref.startsWith(SELF)) && StringUtils.isNotEmpty((CharSequence)(space = this.spaceResolver.getSpaceKey(migratedDocRef)))) {
                ref = StringUtils.replaceOnce((String)ref, (String)SELF, (String)space);
            }
            if ((r = this.confluenceResourceReferenceResolver.resolve(type, ref)) != null) {
                s.incSuccessfulRefs();
                EntityReference wikiRef = migratedDocRef.getRoot();
                if (wikiRef.getType() == EntityType.WIKI && r.getReference().startsWith(wikiRef.getName() + ":")) {
                    r.setReference(r.getReference().substring(wikiRef.getName().length() + 1));
                }
                this.logger.info(SUCCESSFUL_REFERENCE_CONVERSION_MARKER, "Document [{}]: Converting Confluence reference [{}:{}] to [{}]", new Object[]{migratedDocRef, type.getId(), reference, r});
                return r;
            }
            this.logger.warn(FAILED_REFERENCE_CONVERSION_MARKER, "Document [{}]: Failed to convert Confluence reference [{}:{}]", new Object[]{migratedDocRef, type.getId(), reference});
        }
        catch (ConfluenceResolverException e) {
            this.logger.error(FAILED_REFERENCE_CONVERSION_MARKER, "Document [{}]: Failed to convert Confluence reference [{}:{}] because of an exception", new Object[]{migratedDocRef, type.getId(), reference, e});
        }
        s.addFailedRef(type.getId() + ":" + reference);
        return null;
    }

    private boolean updateMacroBrokenLinksParams(Stats s, String paramName, Map<String, String> parameters, MacroBlock block, EntityReference migratedDocRef) {
        String oldRef = parameters.get(paramName);
        if (oldRef == null) {
            return false;
        }
        String newRef = this.maybeConvertBrokenLink(s, oldRef, migratedDocRef);
        if (newRef == null) {
            return false;
        }
        this.logger.info(UPDATE_PARAM_LOG, new Object[]{migratedDocRef, block.getId(), paramName, oldRef, newRef});
        block.setParameter(paramName, newRef);
        return true;
    }

    private static int getReferencePrefixLength(String p) {
        if (p.startsWith("page:")) {
            return 5;
        }
        if (p.startsWith("doc:")) {
            return 4;
        }
        if (p.startsWith(DOCUMENT_COL)) {
            return 9;
        }
        if (p.startsWith(ATTACH)) {
            return 7;
        }
        return 0;
    }

    private boolean fixConfluenceRefsInMacroParams(Stats s, MacroBlock block, EntityReference migratedDocRef, String[] baseURLs) {
        boolean updated = false;
        for (Map.Entry parameter : block.getParameters().entrySet()) {
            String newRef;
            String oldRef = (String)parameter.getValue();
            String prefix = "";
            if (StringUtils.isNotEmpty((CharSequence)oldRef) && oldRef.startsWith(DOCUMENT_COL)) {
                oldRef = oldRef.substring(9);
                prefix = DOCUMENT_COL;
            }
            if ((newRef = this.maybeConvertMacroParameter(s, oldRef, migratedDocRef, baseURLs)) == null) continue;
            String paramName = (String)parameter.getKey();
            block.setParameter(paramName, prefix + newRef);
            this.logger.info(UPDATE_PARAM_LOG, new Object[]{migratedDocRef, block.getId(), paramName, oldRef, newRef});
            updated = true;
        }
        return updated;
    }

    private boolean fixBrokenLinksInMacroParameters(Stats s, MacroBlock block, EntityReference migratedDocRef) {
        if (!ALLOWED_BROKEN_LINK_MACROS.contains(block.getId())) {
            return false;
        }
        Map parameters = block.getParameters();
        boolean updated = this.updateMacroBrokenLinksParams(s, "page", parameters, block, migratedDocRef);
        updated = this.updateMacroBrokenLinksParams(s, "reference", parameters, block, migratedDocRef) || updated;
        updated = this.updateMacroBrokenLinksParams(s, DOCUMENT, parameters, block, migratedDocRef) || updated;
        return updated;
    }

    private boolean visitXDOMToFixRefs(Stats s, XDOM xdom, String syntaxId, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType) {
        boolean updated = false;
        OrBlockMatcher matcher = new OrBlockMatcher(new BlockMatcher[]{new ClassBlockMatcher(LinkBlock.class), new ClassBlockMatcher(ImageBlock.class), new ClassBlockMatcher(MacroBlock.class)});
        List blocks = xdom.getBlocks((BlockMatcher)matcher, Block.Axes.DESCENDANT_OR_SELF);
        for (Block b : blocks) {
            updated = this.visitBlockToFixRefs(s, b, syntaxId, migratedDocRef, baseURLs, brokenRefType) || updated;
        }
        return updated;
    }

    private boolean visitBlockToFixRefs(Stats s, Block b, String syntaxId, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType) {
        if (b instanceof MacroBlock) {
            return this.visitMacroBlockToFixRefs(s, syntaxId, migratedDocRef, baseURLs, brokenRefType, (MacroBlock)b);
        }
        if (b instanceof LinkBlock) {
            return this.updateLinkBlockToFixRef(s, (LinkBlock)b, migratedDocRef, baseURLs, brokenRefType);
        }
        if (b instanceof ImageBlock) {
            return this.updateImageBlockToFixRefs(s, (ImageBlock)b, migratedDocRef, baseURLs, brokenRefType);
        }
        return false;
    }

    private boolean updateImageBlockToFixRefs(Stats s, ImageBlock block, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType) {
        org.xwiki.rendering.listener.reference.ResourceReference oldRef = block.getReference();
        org.xwiki.rendering.listener.reference.ResourceReference newRef = this.maybeConvertReference(s, oldRef, migratedDocRef, baseURLs, brokenRefType);
        if (newRef == null) {
            return false;
        }
        this.logger.info("Document [{}]: Updating image: [{}] -> [{}]", new Object[]{migratedDocRef, oldRef, newRef});
        block.getParent().replaceChild((Block)new ImageBlock(newRef, block.isFreeStandingURI(), block.getParameters()), (Block)block);
        return true;
    }

    private boolean updateLinkBlockToFixRef(Stats s, LinkBlock block, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType) {
        org.xwiki.rendering.listener.reference.ResourceReference oldRef = block.getReference();
        org.xwiki.rendering.listener.reference.ResourceReference newRef = this.maybeConvertReference(s, oldRef, migratedDocRef, baseURLs, brokenRefType);
        if (newRef == null) {
            return false;
        }
        this.logger.info("Document [{}]: Updating link: [{}] -> [{}]", new Object[]{migratedDocRef, oldRef, newRef});
        block.getParent().replaceChild((Block)new LinkBlock(block.getChildren(), newRef, block.isFreeStandingURI(), block.getParameters()), (Block)block);
        return true;
    }

    private boolean visitMacroBlockToFixRefs(Stats s, String syntaxId, EntityReference migratedDocRef, String[] baseURLs, BrokenRefType brokenRefType, MacroBlock block) {
        String oldContent;
        MacroBlock b = block;
        boolean updated = false;
        String id = b.getId();
        String newContent = this.visitMacroContentToFixRefs(s, syntaxId, migratedDocRef, baseURLs, id, oldContent = b.getContent(), brokenRefType);
        if (newContent != null) {
            b = new MacroBlock(id, b.getParameters(), newContent, b.isInline());
            block.getParent().replaceChild((Block)b, (Block)block);
            updated = true;
        }
        if (brokenRefType == BrokenRefType.BROKEN_LINKS || brokenRefType == BrokenRefType.UNKNOWN) {
            boolean bl = updated = this.fixBrokenLinksInMacroParameters(s, block, migratedDocRef) || updated;
        }
        if (brokenRefType == BrokenRefType.CONFLUENCE_REFS || brokenRefType == BrokenRefType.UNKNOWN) {
            updated = this.fixConfluenceRefsInMacroParams(s, block, migratedDocRef, baseURLs) || updated;
        }
        return updated;
    }

    private XDOM parse(String text, String syntaxId) {
        XDOM result;
        try {
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
            result = parser.parse((Reader)new StringReader(text));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private String render(Block block, String outputSyntaxId) {
        String result;
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, outputSyntaxId);
            renderer.render(block, (WikiPrinter)printer);
            result = printer.toString();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private String visitMacroContentToFixRefs(Stats s, String syntaxId, EntityReference documentReference, String[] baseURLs, String macroId, String content, BrokenRefType brokenRefType) {
        Macro macro;
        if (!this.componentManager.hasComponent(Macro.class, macroId)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            macro = (Macro)this.componentManager.getInstance(Macro.class, macroId);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup macro [{}], its content will not be converted", (Object)macroId, (Object)e);
            return null;
        }
        ContentDescriptor contentDescriptor = macro.getDescriptor().getContentDescriptor();
        if (contentDescriptor == null || !contentDescriptor.getType().equals(Block.LIST_BLOCK_TYPE)) {
            return null;
        }
        XDOM macroXDOM = this.parse(content, syntaxId);
        boolean updated = this.visitXDOMToFixRefs(s, macroXDOM, syntaxId, documentReference, baseURLs, brokenRefType);
        return updated ? this.render((Block)macroXDOM, syntaxId) : null;
    }
}

