/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.script;

import com.xpn.xwiki.api.Document;
import com.xwiki.confluencepro.internal.DiagramConversionJobRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="confluencepro.diagramconversion")
@Singleton
public class ConfluenceDiagramConverterScriptService
implements ScriptService {
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceResolver<String> resolver;

    public Job createAndRunDiagramConversionJob(Document statusDocument) {
        if (!this.authorization.hasAccess(Right.ADMIN)) {
            return null;
        }
        List<EntityReference> migrationReferences = this.getMigrations(statusDocument);
        List<EntityReference> spaceReferences = this.getSpaces(statusDocument);
        boolean updateInPlace = ConfluenceDiagramConverterScriptService.isTrue(statusDocument, "updateInPlace");
        boolean dryRun = ConfluenceDiagramConverterScriptService.isTrue(statusDocument, "dryRun");
        DiagramConversionJobRequest jobRequest = new DiagramConversionJobRequest(statusDocument.getDocumentReference(), migrationReferences, spaceReferences, updateInPlace, dryRun);
        try {
            return this.jobExecutor.execute("confluence.diagramconversion", (Request)jobRequest);
        }
        catch (JobException e) {
            this.logger.error("Failed to execute the migration job for [{}].", (Object)statusDocument, (Object)e);
            return null;
        }
    }

    private static boolean isTrue(Document statusDocument, String field) {
        return Objects.equals(statusDocument.getValue(field), 1);
    }

    private List<EntityReference> getSpaces(Document statusDocument) {
        List<EntityReference> spaceReferences = Collections.emptyList();
        List spaces = (List)statusDocument.getValue("spaces");
        if (CollectionUtils.isNotEmpty((Collection)spaces)) {
            spaceReferences = new ArrayList<EntityReference>(spaces.size());
            for (String space : spaces) {
                if (!StringUtils.isNotEmpty((CharSequence)space)) continue;
                EntityType spaceType = space.endsWith(".WebHome") ? EntityType.DOCUMENT : EntityType.SPACE;
                EntityReference spaceReference = this.resolver.resolve((Object)space, spaceType, new Object[0]);
                if (spaceReference.getType() == EntityType.DOCUMENT) {
                    spaceReference = spaceReference.getParent();
                }
                spaceReferences.add(spaceReference);
            }
        }
        return spaceReferences;
    }

    private List<EntityReference> getMigrations(Document statusDocument) {
        List<EntityReference> migrationReferences = Collections.emptyList();
        List migrations = (List)statusDocument.getValue("migrations");
        if (CollectionUtils.isNotEmpty((Collection)migrations)) {
            migrationReferences = new ArrayList<EntityReference>(migrations.size());
            for (String migration : migrations) {
                if (!StringUtils.isNotEmpty((CharSequence)migration)) continue;
                migrationReferences.add(this.resolver.resolve((Object)migration, EntityType.DOCUMENT, new Object[0]));
            }
        }
        return migrationReferences;
    }

    public List<String> getDiagramConversionJobId(EntityReference statusDocument) {
        return DiagramConversionJobRequest.getJobId(statusDocument);
    }
}

