/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.job.question.EntitySelection;

public class SpaceQuestion {
    private Map<EntitySelection, Map<String, String>> confluenceSpaces;

    public SpaceQuestion(Map<EntitySelection, Map<String, String>> confluenceSpaces) {
        this.confluenceSpaces = confluenceSpaces;
    }

    public EntitySelection get(EntityReference entityReference) {
        Optional<EntitySelection> maybeSelection = this.confluenceSpaces.keySet().stream().filter(e -> entityReference.equals((Object)e.getEntityReference())).findFirst();
        return maybeSelection.orElse(null);
    }

    public Map<EntitySelection, Map<String, String>> getConfluenceSpaces() {
        return this.confluenceSpaces;
    }

    public void unselectAll() {
        this.setSelectAllSpaces(false);
    }

    public void selectAll() {
        this.setSelectAllSpaces(true);
    }

    public void setSelectAllSpaces(boolean selected) {
        for (EntitySelection entitySelection : this.confluenceSpaces.keySet()) {
            entitySelection.setSelected(selected);
        }
    }

    public boolean isSelected(String docId) {
        EntityReference entityReference = new EntityReference(docId, EntityType.DOCUMENT);
        EntitySelection selection = this.get(entityReference);
        if (selection != null) {
            return selection.isSelected();
        }
        return false;
    }

    public void setSelectedDocuments(Set<EntityReference> confluenceSpaces) {
        for (EntityReference document : confluenceSpaces) {
            EntitySelection entitySelection = this.get(document);
            if (entitySelection == null) continue;
            entitySelection.setSelected(true);
        }
    }
}

