/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component(roles={LinkMappingConverter.class})
@Singleton
public class LinkMappingConverter {
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceResolver<String> entityReferenceResolver;
    private final TypeReference<Map<String, EntityReference>> typeRef = new TypeReference<Map<String, EntityReference>>(){};

    Map<String, EntityReference> convertSpaceLinkMapping(String spaceMapping, String spaceKey) throws JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)spaceMapping)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(EntityReference.class, (JsonDeserializer)new JsonDeserializer<EntityReference>(){

            public EntityReference deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return LinkMappingConverter.this.entityReferenceResolver.resolve((Object)((String)deserializationContext.readValue(jsonParser, String.class)), EntityType.DOCUMENT, new Object[0]);
            }
        });
        mapper.registerModule((Module)simpleModule);
        try {
            return (Map)mapper.readValue(spaceMapping, this.typeRef);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Could not parse the previous link mapping for space [{}], ignoring it.", (Object)spaceKey, (Object)e);
            return new LinkedHashMap<String, EntityReference>();
        }
    }
}

