/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import com.xwiki.confluencepro.internal.DocumentInstanceOutputFilterStream;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.output.BeanOutputFilterStream;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="com.xwiki.confluencepro.internal.DocumentFilterOverrideListener")
@Singleton
public class DocumentFilterOverrideListener
extends AbstractEventListener
implements Initializable {
    public static final String ROLE_HINT = "com.xwiki.confluencepro.internal.DocumentFilterOverrideListener";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Logger logger;

    public DocumentFilterOverrideListener() {
        super(ROLE_HINT, Collections.emptyList());
    }

    public void initialize() throws InitializationException {
        this.maybeReplaceDocumentFilter();
    }

    public void onEvent(Event event, Object source, Object data) {
    }

    private void maybeReplaceDocumentFilter() {
        if (this.shouldOverrideDocumentFilter()) {
            DefaultComponentDescriptor newDescriptor = new DefaultComponentDescriptor();
            newDescriptor.setImplementation(DocumentInstanceOutputFilterStream.class);
            newDescriptor.setInstantiationStrategy(ComponentInstantiationStrategy.PER_LOOKUP);
            newDescriptor.setRoleHint("xwiki+instance+document");
            newDescriptor.setRoleType((Type)new DefaultParameterizedType(null, BeanOutputFilterStream.class, new Type[]{DocumentInstanceOutputProperties.class}));
            DefaultComponentDependency contextProviderDependency = new DefaultComponentDependency();
            contextProviderDependency.setRoleType((Type)new DefaultParameterizedType(null, Provider.class, new Type[]{XWikiContext.class}));
            contextProviderDependency.setName("xcontextProvider");
            DefaultComponentDependency documentListenerDependency = new DefaultComponentDependency();
            documentListenerDependency.setRoleType((Type)new DefaultParameterizedType(null, EntityOutputFilterStream.class, new Type[]{XWikiDocument.class}));
            documentListenerDependency.setName("documentListener");
            DefaultComponentDependency userResolverDependency = new DefaultComponentDependency();
            userResolverDependency.setRoleType((Type)new DefaultParameterizedType(null, UserReferenceResolver.class, new Type[]{DocumentReference.class}));
            userResolverDependency.setRoleHint("document");
            userResolverDependency.setName("documentReferenceUserReferenceResolver");
            DefaultComponentDependency loggerDependency = new DefaultComponentDependency();
            loggerDependency.setRoleType(Logger.class);
            loggerDependency.setName("logger");
            DefaultComponentDependency filterDescriptorDependency = new DefaultComponentDependency();
            filterDescriptorDependency.setRoleType(FilterDescriptorManager.class);
            filterDescriptorDependency.setName("filterManager");
            newDescriptor.addComponentDependency((ComponentDependency)filterDescriptorDependency);
            newDescriptor.addComponentDependency((ComponentDependency)loggerDependency);
            newDescriptor.addComponentDependency((ComponentDependency)contextProviderDependency);
            newDescriptor.addComponentDependency((ComponentDependency)documentListenerDependency);
            newDescriptor.addComponentDependency((ComponentDependency)userResolverDependency);
            try {
                this.componentManager.registerComponent((ComponentDescriptor)newDescriptor);
            }
            catch (ComponentRepositoryException e) {
                this.logger.warn("Failed to replace the DocumentInstanceOutputFilterStream class from the component manager. Cause: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private boolean shouldOverrideDocumentFilter() {
        return this.coreExtensionRepository.getEnvironmentExtension().getId().getVersion().compareTo((Object)new DefaultVersion("15.10.6")) <= 0;
    }
}

