/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.confluencepro.internal.MigrationFixingStats;
import com.xwiki.confluencepro.internal.MigrationFixingTools;
import com.xwiki.diagram.script.DiagramScriptService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.contrib.confluence.resolvers.ConfluencePageIdResolver;
import org.xwiki.contrib.confluence.resolvers.ConfluenceResolverException;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.script.service.ScriptService;

@Component(roles={DiagramConverter.class})
@Singleton
public class DiagramConverter {
    private static final ClassBlockMatcher MACRO_MATCHER = new ClassBlockMatcher(MacroBlock.class);
    private static final String DIAGRAM_CLASS = "DiagramClass";
    private static final String FAILED_TO_UPDATE_DIAGRAM = "Document [{}]: failed to update diagram";
    private static final String DRAWIO = "drawio";
    private static final String GLIFFY = "gliffy";
    private static final String[] DIAGRAM_MACRO_NAMES = new String[]{"gliffy", "drawio"};
    private static final EntityReference DIAGRAM_CLASS_REFERENCE = new LocalDocumentReference("Diagram", "DiagramClass");
    private static final EntityReference DIAGRAM_PRO_CLASS_REFERENCE = new LocalDocumentReference(List.of("Confluence", "Macros"), "DiagramClass");
    private static final TypeReference<Map<String, Map<String, Integer>>> MACRO_PAGES_TYPE_REF = new TypeReference<Map<String, Map<String, Integer>>>(){};
    private static final String CONFLUENCE_UNDERSCORE = "confluence_";
    private static final String DIAGRAM_NAME = "diagramName";
    @Inject
    private MigrationFixingTools migrationFixingTools;
    @Inject
    private Logger logger;
    @Inject
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="diagram")
    private ScriptService diagramService;
    @Inject
    private ConfluencePageIdResolver pageIdResolver;

    public MigrationFixingStats fixDocuments(List<EntityReference> migrationReferences, List<EntityReference> spaceReferences, boolean updateInPlace, boolean dryRun) {
        Stats s = new Stats();
        this.migrationFixingTools.fixDocuments((MigrationFixingStats)s, migrationReferences, spaceReferences, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, updateInPlace, dryRun), migrationDoc -> this.fixDocumentsOfMigration(s, (XWikiDocument)migrationDoc, updateInPlace, dryRun));
        return s;
    }

    private void fixDocumentsOfMigration(Stats s, XWikiDocument migrationDoc, boolean updateInPlace, boolean dryRun) {
        Map macroPages = null;
        XWikiAttachment macroPagesAttachment = migrationDoc.getAttachment("macroPages.json");
        if (macroPagesAttachment != null) {
            XWikiAttachmentContent attachmentContent = null;
            try {
                attachmentContent = macroPagesAttachment.getAttachmentContent((XWikiContext)this.contextProvider.get());
            }
            catch (XWikiException e) {
                this.logger.error("Failed get macro pages data", (Throwable)e);
            }
            if (attachmentContent != null) {
                try {
                    InputStream contentInputStream = attachmentContent.getContentInputStream();
                    macroPages = (Map)new ObjectMapper().readValue(contentInputStream, MACRO_PAGES_TYPE_REF);
                }
                catch (IOException e) {
                    this.logger.error("Failed to read macro pages", (Throwable)e);
                }
            }
        }
        if (macroPages == null) {
            this.logger.warn("Failed to find the list of affected pages in macroPages.json, will browse all the documents");
            this.migrationFixingTools.fixDocumentsOfMigration(migrationDoc, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, updateInPlace, dryRun));
        } else {
            ArrayList<String> docs = new ArrayList<String>();
            for (Map.Entry macroPageEntry : macroPages.entrySet()) {
                Map macroInfo = (Map)macroPageEntry.getValue();
                if (!DiagramConverter.hasDiagram(macroInfo)) continue;
                docs.add((String)macroPageEntry.getKey());
            }
            this.migrationFixingTools.fixDocuments(docs, migratedDoc -> this.fixDocument(s, (XWikiDocument)migratedDoc, updateInPlace, dryRun));
        }
    }

    private static boolean hasDiagram(Map<String, Integer> macroInfo) {
        for (String macroName : DIAGRAM_MACRO_NAMES) {
            if (macroInfo.getOrDefault(CONFLUENCE_UNDERSCORE + macroName, 0) <= 0 && macroInfo.getOrDefault(macroName, 0) <= 0) continue;
            return true;
        }
        return false;
    }

    private static XDOM parse(ComponentManager componentManager, String text, String syntaxId) {
        XDOM result;
        try {
            Parser parser = (Parser)componentManager.getInstance(Parser.class, syntaxId);
            result = parser.parse((Reader)new StringReader(text));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private XDOM getMacroXDOM(MacroBlock macroBlock, String syntaxId) throws ComponentLookupException {
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (componentManager.hasComponent(Macro.class, macroBlock.getId())) {
            ContentDescriptor macroContentDescriptor = ((Macro)componentManager.getInstance(Macro.class, macroBlock.getId())).getDescriptor().getContentDescriptor();
            if (macroContentDescriptor != null && macroContentDescriptor.getType().equals(Block.LIST_BLOCK_TYPE) && StringUtils.isNotBlank((CharSequence)macroBlock.getContent())) {
                return DiagramConverter.parse(componentManager, macroBlock.getContent(), syntaxId);
            }
        } else if (StringUtils.isNotBlank((CharSequence)macroBlock.getContent())) {
            this.logger.debug("Calling parse on unknown macro [{}] with syntax [{}]", (Object)macroBlock.getId(), (Object)syntaxId);
            return DiagramConverter.parse(componentManager, macroBlock.getContent(), syntaxId);
        }
        return null;
    }

    private boolean convertDiagramMacros(Stats s, XWikiDocument migratedDoc, XDOM xdom, String syntaxId, boolean dryRun) {
        boolean updated = false;
        List macros = xdom.getBlocks((BlockMatcher)MACRO_MATCHER, Block.Axes.DESCENDANT_OR_SELF);
        for (MacroBlock macroBlock : macros) {
            try {
                if (DiagramConverter.shouldConvertMacro(macroBlock)) {
                    updated = this.convertDiagramMacro(s, migratedDoc, dryRun, macroBlock) || updated;
                    continue;
                }
                XDOM macroXDOM = this.getMacroXDOM(macroBlock, syntaxId);
                if (macroXDOM == null) continue;
                updated = this.convertDiagramMacros(s, migratedDoc, macroXDOM, syntaxId, dryRun) || updated;
            }
            catch (ComponentLookupException e) {
                this.logger.error("Component lookup error trying to find the diagram macro", (Throwable)e);
            }
        }
        return updated;
    }

    private static boolean shouldConvertMacro(MacroBlock macroBlock) {
        for (String macroName : DIAGRAM_MACRO_NAMES) {
            String id = macroBlock.getId();
            if (!(CONFLUENCE_UNDERSCORE + macroName).equals(id) && !macroName.equals(id)) continue;
            return true;
        }
        return false;
    }

    private boolean convertDiagramMacro(Stats s, XWikiDocument migratedDoc, boolean dryRun, MacroBlock macroBlock) {
        boolean updated = false;
        try {
            if (this.convertDiagramMacro(migratedDoc, macroBlock, dryRun)) {
                updated = true;
                s.incSuccessfulDiagrams();
            } else {
                this.logger.error(FAILED_TO_UPDATE_DIAGRAM, (Object)migratedDoc.getDocumentReference());
                s.incFailedDiagrams();
            }
        }
        catch (XWikiException e) {
            this.logger.error(FAILED_TO_UPDATE_DIAGRAM, (Object)migratedDoc.getDocumentReference(), (Object)e);
            s.incFailedDiagrams();
        }
        return updated;
    }

    private boolean convertDiagramMacro(XWikiDocument migratedDoc, MacroBlock macroBlock, boolean dryRun) throws XWikiException {
        String reference = this.getDiagramDocRef(migratedDoc, macroBlock, dryRun);
        if (StringUtils.isEmpty((CharSequence)reference)) {
            return false;
        }
        Map<String, String> diagramParameters = Map.of("reference", reference, "cached", "false");
        macroBlock.getParent().replaceChild(List.of(new MacroBlock("diagram", diagramParameters, macroBlock.isInline())), (Block)macroBlock);
        return true;
    }

    private String getDiagramDocRef(XWikiDocument migratedDoc, MacroBlock macroBlock, boolean dryRun) throws XWikiException {
        XWikiDocument diagramDoc;
        DocumentReference migratedDocRef = migratedDoc.getDocumentReference();
        String diagramName = macroBlock.getParameter("name");
        if (StringUtils.isEmpty((CharSequence)diagramName)) {
            diagramName = macroBlock.getParameter(DIAGRAM_NAME);
        }
        if (StringUtils.isEmpty((CharSequence)diagramName)) {
            this.logger.warn("Document [{}]: a [{}] macro is missing a diagram name", (Object)migratedDocRef, (Object)macroBlock.getId());
            return null;
        }
        String targetDiagramName = diagramName;
        if (targetDiagramName.endsWith(".drawio")) {
            targetDiagramName = diagramName.substring(0, diagramName.length() - 7);
        }
        if ((diagramDoc = this.maybeCreateDiagramDoc(migratedDoc, macroBlock, diagramName, targetDiagramName, dryRun)) == null) {
            return null;
        }
        return (String)this.serializer.serialize((EntityReference)diagramDoc.getDocumentReference(), new Object[]{migratedDocRef});
    }

    private XWikiDocument maybeCreateDiagramDoc(XWikiDocument migratedDoc, MacroBlock macroBlock, String diagramName, String targetDiagramName, boolean dryRun) throws XWikiException {
        String pageid = macroBlock.getParameter("pageid");
        XWikiDocument docContainingDiagram = this.getDocumentContainingDiagram(migratedDoc, diagramName, pageid);
        if (docContainingDiagram == null) {
            return null;
        }
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        EntityReference parent = docContainingDiagram.getDocumentReference().getParent();
        EntityReference convertedDiagramDocRef = new EntityReference(targetDiagramName, EntityType.DOCUMENT, parent);
        XWikiDocument convertedDiagramDoc = context.getWiki().getDocument(convertedDiagramDocRef, context);
        if (convertedDiagramDoc.isNew()) {
            String diagramContent = this.getDiagramContent(migratedDoc, diagramName, macroBlock.getId(), docContainingDiagram);
            DocumentReference migratedDocRef = migratedDoc.getDocumentReference();
            if (StringUtils.isEmpty((CharSequence)diagramContent)) {
                if (dryRun) {
                    this.logger.warn("Document [{}]: would fail to convert diagram [{}]", (Object)migratedDocRef, (Object)diagramName);
                }
                return null;
            }
            if (dryRun) {
                this.logger.info("Document [{}]: would successfully convert diagram [{}]", (Object)migratedDocRef, (Object)diagramName);
                return convertedDiagramDoc;
            }
            convertedDiagramDoc.newXObject(DIAGRAM_CLASS_REFERENCE, context);
            BaseObject diagramObject = convertedDiagramDoc.newXObject(DIAGRAM_PRO_CLASS_REFERENCE, context);
            diagramObject.setDBStringListValue("page", List.of((String)this.serializer.serialize((EntityReference)migratedDocRef, new Object[0])));
            diagramObject.setStringValue(DIAGRAM_NAME, targetDiagramName);
            convertedDiagramDoc.setTitle("Diagram " + targetDiagramName);
            convertedDiagramDoc.setContent(diagramContent);
            context.getWiki().saveDocument(convertedDiagramDoc, context);
        }
        return convertedDiagramDoc;
    }

    private String getDiagramContent(XWikiDocument migratedDoc, String diagramName, String macroName, XWikiDocument docContainingDiagram) {
        XWikiAttachment diagramAttach = docContainingDiagram.getAttachment(diagramName);
        if (diagramAttach == null) {
            this.logger.error("Document [{}]: diagram attachment [{}] is missing", (Object)migratedDoc.getDocumentReference(), (Object)diagramName);
            return null;
        }
        String diagramContent = "";
        try {
            XWikiAttachmentContent attachmentContent = diagramAttach.getAttachmentContent((XWikiContext)this.contextProvider.get());
            InputStream attachmentInputStream = attachmentContent.getContentInputStream();
            diagramContent = new String(attachmentInputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (XWikiException | IOException e) {
            this.logger.error("Document [{}]: failed to get diagram attachment [{}] on document [{}]", new Object[]{migratedDoc.getDocumentReference(), diagramName, docContainingDiagram});
            return null;
        }
        if (diagramContent.isEmpty()) {
            this.logger.error("Document [{}]: diagram attachment [{}] on document [{}] is empty", new Object[]{migratedDoc.getDocumentReference(), docContainingDiagram, diagramName});
        } else if (!macroName.endsWith(DRAWIO)) {
            try {
                return ((DiagramScriptService)this.diagramService).importDiagram(diagramContent, diagramName);
            }
            catch (Exception e) {
                this.logger.error("Diagram conversion threw an exception", (Throwable)e);
                return null;
            }
        }
        return diagramContent;
    }

    private XWikiDocument getDocumentContainingDiagram(XWikiDocument migratedDoc, String diagramName, String pageIdStr) {
        XWikiDocument docContainingDiagram = migratedDoc;
        if (StringUtils.isNotEmpty((CharSequence)pageIdStr)) {
            try {
                long pageId = Long.parseLong(pageIdStr, 10);
                EntityReference docReferencedByTheMacro = this.pageIdResolver.getDocumentById(pageId);
                if (docReferencedByTheMacro == null) {
                    this.logger.error("Document [{}]: could not find page id [{}] for diagram [{}]", new Object[]{migratedDoc.getDocumentReference(), pageIdStr, diagramName});
                } else {
                    XWikiContext context = (XWikiContext)this.contextProvider.get();
                    XWikiDocument d = context.getWiki().getDocument(docReferencedByTheMacro, context);
                    if (d.isNew()) {
                        this.logger.error("Document [{}]: page id [{}] for diagram [{}] is the new document [{}] ", new Object[]{migratedDoc, pageIdStr, diagramName, docReferencedByTheMacro});
                    } else {
                        docContainingDiagram = d;
                    }
                }
            }
            catch (XWikiException e) {
                this.logger.error("Document [{}]: could get document page id [{}] for diagram [{}]", new Object[]{migratedDoc.getDocumentReference(), pageIdStr, diagramName});
            }
            catch (NumberFormatException e) {
                this.logger.error("Document [{}]: could not parse page id [{}] for diagram [{}]", new Object[]{migratedDoc.getDocumentReference(), pageIdStr, diagramName});
            }
            catch (ConfluenceResolverException e) {
                this.logger.error("Document [{}]: failed to resolve page id [{}] for diagram [{}]", new Object[]{migratedDoc.getDocumentReference(), pageIdStr, diagramName, e});
            }
        }
        return docContainingDiagram;
    }

    private void fixDocument(Stats s, XWikiDocument migratedDoc, boolean updateInPlace, boolean dryRun) {
        XDOM xdom = migratedDoc.getXDOM();
        boolean updated = this.convertDiagramMacros(s, migratedDoc, xdom, migratedDoc.getSyntax().toIdString(), dryRun);
        if (updated && !dryRun) {
            try {
                migratedDoc.setContent(xdom);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to update the document XDOM [{}]", (Object)migratedDoc.getDocumentReference(), (Object)e);
                s.incFailedDocs();
                return;
            }
        }
        this.migrationFixingTools.handleDocumentUpdate((MigrationFixingStats)s, migratedDoc, updated, updateInPlace, dryRun, "Convert Confluence diagrams");
    }

    private static final class Stats
    implements MigrationFixingStats {
        private int failedDocs;
        private int successfulDocs;
        private int unchangedDocs;
        private int successfulDiagrams;
        private int failedDiagrams;

        private Stats() {
        }

        public void incFailedDocs() {
            ++this.failedDocs;
        }

        public void incSuccessfulDocs() {
            ++this.successfulDocs;
        }

        public void incUnchangedDocs() {
            ++this.unchangedDocs;
        }

        void incSuccessfulDiagrams() {
            ++this.successfulDiagrams;
        }

        void incFailedDiagrams() {
            ++this.failedDiagrams;
        }

        public String toJSON() {
            return "{\"failedDocs\": " + this.failedDocs + ", \"successfulDocs\": " + this.successfulDocs + ", \"unchangedDocs\": " + this.unchangedDocs + ", \"successfulDiagrams\": " + this.successfulDiagrams + ", \"failedDiagrams\": " + this.failedDiagrams + "}";
        }
    }
}

