/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.confluencepro.internal.DiagramConversionJobRequest;
import com.xwiki.confluencepro.internal.DiagramConverter;
import com.xwiki.confluencepro.internal.MigrationFixingStats;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="confluence.diagramconversion")
public class DiagramConversionJob
extends AbstractJob<DiagramConversionJobRequest, DefaultJobStatus<DiagramConversionJobRequest>>
implements GroupedJob {
    static final String JOBTYPE = "confluence.diagramconversion";
    private static final JobGroupPath GROUP = new JobGroupPath(Arrays.asList("confluencemigratorpro", "diagramconversion"));
    private static final LocalDocumentReference REFERENCE_FIXING_CLASS = new LocalDocumentReference(List.of("ConfluenceMigratorPro", "DiagramFixer", "Code"), "DiagramConversionClass");
    private static final String EXECUTED = "executed";
    @Inject
    private DiagramConverter diagramConverter;
    @Inject
    private Provider<XWikiContext> contextProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        DocumentReference statusDocumentReference = ((DiagramConversionJobRequest)this.request).getStatusDocumentReference();
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki wiki = context.getWiki();
        XWikiDocument document = wiki.getDocument(statusDocumentReference, context);
        document.setIntValue((EntityReference)REFERENCE_FIXING_CLASS, EXECUTED, 2);
        wiki.saveDocument(document, "Start session", context);
        this.logger.info("Starting diagram conversion job");
        MigrationFixingStats s = null;
        try {
            s = this.diagramConverter.fixDocuments(((DiagramConversionJobRequest)this.request).getMigrationReferences(), ((DiagramConversionJobRequest)this.request).getSpaceReferences(), ((DiagramConversionJobRequest)this.request).isUpdateInPlace(), ((DiagramConversionJobRequest)this.request).isDryRun());
        }
        catch (Exception e) {
            document = wiki.getDocument(statusDocumentReference, context);
            document.setIntValue((EntityReference)REFERENCE_FIXING_CLASS, EXECUTED, 3);
            wiki.saveDocument(document, "End failed conversion", context);
            this.logger.error("Diagram conversion job failed with an exception", (Throwable)e);
        }
        finally {
            document = wiki.getDocument(statusDocumentReference, context);
            document.setIntValue((EntityReference)REFERENCE_FIXING_CLASS, EXECUTED, 1);
            if (s != null) {
                this.addAttachment("stats.json", s.toJSON(), document);
            }
            wiki.saveDocument(document, "End session", context);
        }
        this.logger.info("Finished diagram conversion job");
    }

    private void addAttachment(String name, String content, XWikiDocument document) {
        XWikiAttachment a = new XWikiAttachment(document, name);
        XWikiAttachmentContent attachmentContent = new XWikiAttachmentContent(a);
        try {
            attachmentContent.setContent((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            this.logger.error("Could not save [{}]", (Object)name, (Object)e);
        }
        a.setAttachment_content(attachmentContent);
        document.setAttachment(a);
    }

    public JobGroupPath getGroupPath() {
        return GROUP;
    }

    public String getType() {
        return JOBTYPE;
    }
}

