/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.confluencepro.ConfluenceMigrationJobRequest;
import com.xwiki.confluencepro.ConfluenceMigrationJobStatus;
import com.xwiki.confluencepro.ConfluenceMigrationManager;
import com.xwiki.confluencepro.MigrationExtraDetails;
import com.xwiki.confluencepro.internal.ConfluenceFilteringListener;
import com.xwiki.confluencepro.internal.ConfluenceMigrationPrerequisitesManager;
import com.xwiki.confluencepro.script.ConfluenceMigrationScriptService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.ConfluenceFilter;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultConfluenceMigrationManager
implements ConfluenceMigrationManager {
    private static final String OCCURRENCES_KEY = "occurrences";
    private static final String PAGES_KEY = "pages";
    private static final List<String> CONFLUENCE_MIGRATOR_SPACE = Arrays.asList("ConfluenceMigratorPro", "Code");
    private static final LocalDocumentReference MIGRATION_OBJECT = new LocalDocumentReference(CONFLUENCE_MIGRATOR_SPACE, "MigrationClass");
    private static final Marker CONFLUENCE_REF_MARKER = MarkerFactory.getMarker((String)"confluenceRef");
    private static final String EXECUTED = "executed";
    private static final String AN_EXCEPTION_OCCURRED = "An exception occurred";
    private static final String DATA_JSON = "data.json";
    private static final TypeReference<Map<String, String>> STRING_MAP_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<Map<String, Map<String, Integer>>> COUNT_MAP_TYPE_REF = new TypeReference<Map<String, Map<String, Integer>>>(){};
    private static final TypeReference<Map<String, Map<String, Set<?>>>> DOCS_MAP_TYPE_REF = new TypeReference<Map<String, Map<String, Set<?>>>>(){};
    private static final String PAGE_ID = "pageId";
    private static final Marker SEND_PAGE_MARKER = MarkerFactory.getMarker((String)"ConfluenceSendingPage");
    private static final Marker SEND_TEMPLATE_MARKER = MarkerFactory.getMarker((String)"ConfluenceSendingTemplate");
    private static final Marker UNHANDLED_PARAMETER_MARKER = MarkerFactory.getMarker((String)"unhandledConfluenceParameter");
    private static final Marker UNHANDLED_PARAMETER_VALUE_MARKER = MarkerFactory.getMarker((String)"unhandledConfluenceParameterValue");
    private static final String OTHER_ISSUES = "otherIssues";
    private static final String SKIPPED = "skipped";
    private static final String CONFLUENCE_REF_WARNINGS = "confluenceRefWarnings";
    private static final String UNHANDLED_PARAMETERS = "unhandledParameters";
    private static final String UNHANDLED_PARAMETER_VALUES = "unhandledParameterValues";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private ConfluenceMigrationPrerequisitesManager prerequisitesManager;
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    private EntityReferenceResolver<String> referenceResolver;
    @Inject
    private MigrationExtraDetails migrationExtraDetails;

    public void updateAndSaveMigration(ConfluenceMigrationJobStatus jobStatus) {
        block8: {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiDocument document = null;
            BaseObject object = null;
            XWiki wiki = context.getWiki();
            DocumentReference statusDocumentReference = ((ConfluenceMigrationJobRequest)jobStatus.getRequest()).getStatusDocumentReference();
            try {
                document = wiki.getDocument(statusDocumentReference, context).clone();
                object = document.getXObject((EntityReference)MIGRATION_OBJECT);
                object.set(EXECUTED, (Object)(jobStatus.isCanceled() ? 3 : 1), context);
                object.setStringListValue("spaces", new ArrayList(jobStatus.getSpaces()));
                this.completeExtraDetails(object, context);
                String root = this.updateMigrationPropertiesAndGetRoot(object);
                Map<String, Map<String, Integer>> macroPages = this.analyseLogs(jobStatus, object, document, root);
                if (!ConfluenceFilteringListener.isTrue(((ConfluenceMigrationJobRequest)jobStatus.getRequest()).getOutputProperties().getOrDefault("onlyLinkMapping", "0").toString())) {
                    HashMap<String, Integer> macroCounts = new HashMap<String, Integer>();
                    for (Map<String, Integer> entries : macroPages.values()) {
                        for (Map.Entry<String, Integer> entry : entries.entrySet()) {
                            String macroName = entry.getKey();
                            macroCounts.put(macroName, entry.getValue() + macroCounts.computeIfAbsent(macroName, k -> 0));
                        }
                    }
                    object.setLargeStringValue("macros", new ObjectMapper().writeValueAsString(macroCounts));
                    this.persistMacroMap(macroPages);
                }
                if (StringUtils.isEmpty((CharSequence)document.getTitle())) {
                    document.setTitle(statusDocumentReference.getName());
                }
                wiki.saveDocument(document, "Migration executed!", context);
                this.logger.info("Migration finished and saved");
            }
            catch (Exception e) {
                if (object == null) break block8;
                object.set(EXECUTED, (Object)4, context);
                this.logger.error(AN_EXCEPTION_OCCURRED, (Throwable)e);
                try {
                    wiki.saveDocument(document, "Migration failed", context);
                }
                catch (XWikiException err) {
                    this.logger.error("Could not update the migration document [{}] with an error status", (Object)statusDocumentReference, (Object)err);
                }
            }
        }
    }

    private void completeExtraDetails(BaseObject object, XWikiContext context) throws JsonProcessingException {
        object.set("extensions", (Object)this.migrationExtraDetails.identifyDependencyVersions(), context);
        object.set("licenseType", (Object)this.migrationExtraDetails.identifyLicenseType(), context);
    }

    private String updateMigrationPropertiesAndGetRoot(BaseObject object) {
        try {
            this.removeDefaultProperties(object, "outputProperties", ConfluenceMigrationScriptService.PREFILLED_OUTPUT_PARAMETERS);
            return this.removeDefaultProperties(object, "inputProperties", ConfluenceMigrationScriptService.PREFILLED_INPUT_PARAMETERS).get("root");
        }
        catch (JsonProcessingException e) {
            this.logger.error("Could not save the input and output properties of the migration", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> removeDefaultProperties(BaseObject object, String field, Map<String, String> defaults) throws JsonProcessingException {
        boolean update = false;
        String value = object.getLargeStringValue(field);
        Map props = (Map)new ObjectMapper().readValue(value, STRING_MAP_TYPE_REF);
        for (Map.Entry<String, String> def : defaults.entrySet()) {
            String key = def.getKey();
            String v = (String)props.get(key);
            if (v == null || !v.equals(def.getValue())) continue;
            props.remove(key);
            update = true;
        }
        if (update) {
            object.setLargeStringValue(field, new ObjectMapper().writeValueAsString((Object)props));
        }
        return props;
    }

    private void replaceKey(Map<String, List<LogLine<SimpleLog>>> m, CurrentPage currentPage) {
        String oldKey = DefaultConfluenceMigrationManager.toString(currentPage.id);
        String newKey = currentPage.ref;
        if (m.containsKey(oldKey)) {
            List<LogLine<SimpleLog>> l = m.get(newKey);
            if (l == null) {
                m.put(newKey, m.remove(oldKey));
            } else {
                l.addAll((Collection<LogLine<SimpleLog>>)m.remove(oldKey));
            }
        }
    }

    private boolean ignoredIssue(LogEvent event) {
        if ("Failed to send event [{}] to listener [{}]".equals(event.getMessage())) {
            Object[] args = event.getArgumentArray();
            return args.length == 2 && args[0] instanceof DocumentUpdatedEvent && args[1] instanceof String && ((String)args[1]).startsWith("com.xpn.xwiki.internal.event.AttachmentEventGeneratorListener@");
        }
        return false;
    }

    Map<String, Map<String, Integer>> analyseLogs(ConfluenceMigrationJobStatus jobStatus, BaseObject object, XWikiDocument document, String root) {
        Map<String, Map<String, List<LogLine<SimpleLog>>>> logCategories = Map.of(OTHER_ISSUES, new TreeMap(), SKIPPED, new TreeMap(), CONFLUENCE_REF_WARNINGS, new TreeMap(), UNHANDLED_PARAMETERS, new TreeMap(), UNHANDLED_PARAMETER_VALUES, new TreeMap());
        HashMap<String, Map<String, Integer>> macroPages = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Map<String, List<String>>> collisions = new HashMap<String, Map<String, List<String>>>();
        CurrentPage currentPage = new CurrentPage();
        DocCounts counts = new DocCounts();
        HashSet<String> docs = new HashSet<String>();
        for (LogEvent event : jobStatus.getLogTail()) {
            if (event == null) {
                this.logger.warn("Found a null event. This is unexpected.");
                continue;
            }
            this.analyseLogEvent(event, currentPage, docs, logCategories, macroPages, counts, collisions);
        }
        for (Map.Entry catEntry : logCategories.entrySet()) {
            this.addAttachment(catEntry.getKey() + ".json", catEntry.getValue(), document);
        }
        this.addAttachment("missingUsersGroups.json", this.getPermissionIssues(root, docs), document);
        this.addAttachment("collisions.json", collisions, document);
        this.addAttachment("macroPages.json", macroPages, document);
        object.setLongValue("imported", counts.docCount);
        object.setLongValue("templates", counts.templateCount);
        object.setLongValue("revisions", counts.revisionCount);
        return macroPages;
    }

    private void analyseLogEvent(LogEvent event, CurrentPage currentPage, Collection<String> docs, Map<String, Map<String, List<LogLine<SimpleLog>>>> logCategories, Map<String, Map<String, Integer>> macroPages, DocCounts counts, Map<String, Map<String, List<String>>> collisions) {
        Marker marker = event.getMarker();
        if (DefaultConfluenceMigrationManager.isADocumentOutputFilterEvent(marker)) {
            this.updateCurrentPage(event, currentPage, docs, logCategories);
        } else if (ConfluenceFilter.LOG_MACROS_FOUND.equals((Object)marker)) {
            DefaultConfluenceMigrationManager.addMacros(currentPage, event.getArgumentArray(), macroPages);
        } else if (SEND_PAGE_MARKER.equals((Object)marker)) {
            DefaultConfluenceMigrationManager.updateCountsAndRef(event, currentPage, counts);
        } else if (SEND_TEMPLATE_MARKER.equals((Object)marker)) {
            ++counts.templateCount;
        } else if (UNHANDLED_PARAMETER_MARKER.equals((Object)marker)) {
            DefaultConfluenceMigrationManager.addEventToCat(event, logCategories.get(UNHANDLED_PARAMETERS), currentPage);
        } else if (UNHANDLED_PARAMETER_VALUE_MARKER.equals((Object)marker)) {
            DefaultConfluenceMigrationManager.addEventToCat(event, logCategories.get(UNHANDLED_PARAMETER_VALUES), currentPage);
        } else if (CONFLUENCE_REF_MARKER.equals((Object)event.getMarker())) {
            DefaultConfluenceMigrationManager.addEventToCat(event, logCategories.get(CONFLUENCE_REF_WARNINGS), currentPage);
        } else if (LogLevel.WARN.equals((Object)event.getLevel())) {
            DefaultConfluenceMigrationManager.addEventToCat(event, logCategories.get(OTHER_ISSUES), currentPage);
        } else if (LogLevel.ERROR.equals((Object)event.getLevel())) {
            this.updateErrors(event, logCategories.get(SKIPPED), collisions, currentPage);
        }
    }

    private void updateCurrentPage(LogEvent event, CurrentPage currentPage, Collection<String> docs, Map<String, Map<String, List<LogLine<SimpleLog>>>> logCategories) {
        Object[] args = event.getArgumentArray();
        if (args.length > 0 && args[0] instanceof DocumentReference) {
            DocumentReference docRef = (DocumentReference)args[0];
            currentPage.ref = (String)this.serializer.serialize((EntityReference)docRef, new Object[0]);
            docs.add((String)this.localSerializer.serialize((EntityReference)docRef, new Object[0]));
            if (currentPage.id != null) {
                for (Map<String, List<LogLine<SimpleLog>>> cat : logCategories.values()) {
                    this.replaceKey(cat, currentPage);
                }
            }
        }
    }

    private void updateErrors(LogEvent event, Map<String, List<LogLine<SimpleLog>>> skipped, Map<String, Map<String, List<String>>> collisions, CurrentPage currentPage) {
        Object[] args = event.getArgumentArray();
        if (DefaultConfluenceMigrationManager.isACollisionError(event, args)) {
            String collidingReference = (String)args[0];
            String spaceKey = (String)args[1];
            List pages = (List)args[2];
            Map spaceEntry = collisions.computeIfAbsent(spaceKey, k -> new HashMap());
            spaceEntry.put(collidingReference, pages);
        } else if (!this.ignoredIssue(event)) {
            DefaultConfluenceMigrationManager.addEventToCat(event, skipped, currentPage);
        }
    }

    private static boolean isACollisionError(LogEvent event, Object[] args) {
        if (Objects.equals(event.getMarker(), ConfluenceFilteringListener.COLLISION_MARKER)) {
            return args.length == 3 && args[0] instanceof String && args[1] instanceof String && args[2] instanceof List;
        }
        return false;
    }

    private static void addMacros(CurrentPage currentPage, Object[] args, Map<String, Map<String, Integer>> macroPages) {
        if (currentPage.ref != null && currentPage.isCurrentRevision() && args[0] instanceof Map) {
            Map macrosIds = (Map)args[0];
            macroPages.put(currentPage.ref, DefaultConfluenceMigrationManager.mergeMacroIds(macrosIds, macroPages.get(currentPage.ref)));
        }
    }

    private static Map<String, Integer> mergeMacroIds(Map<String, Integer> newMacrosIds, Map<String, Integer> oldMacrosIds) {
        if (oldMacrosIds == null) {
            return newMacrosIds;
        }
        LinkedHashMap<String, Integer> macroIds = new LinkedHashMap<String, Integer>(newMacrosIds);
        for (Map.Entry<String, Integer> entry : oldMacrosIds.entrySet()) {
            String id = entry.getKey();
            macroIds.put(entry.getKey(), Math.max(entry.getValue(), macroIds.getOrDefault(id, 0)));
        }
        return macroIds;
    }

    private static boolean isADocumentOutputFilterEvent(Marker marker) {
        String markerName = marker == null || marker.getName() == null ? "" : marker.getName();
        return markerName.equals("filter.instance.log.document.updated") || markerName.equals("filter.instance.log.document.created");
    }

    private static <T> T getPageIdentifierField(Map<?, ?> pageIdentifier, String field, Class<T> clazz) {
        Object f = pageIdentifier.get(field);
        if (clazz.isInstance(f)) {
            return clazz.cast(f);
        }
        return null;
    }

    private static void updateCountsAndRef(LogEvent event, CurrentPage currentPage, DocCounts counts) {
        currentPage.ref = null;
        ++counts.revisionCount;
        if (DefaultConfluenceMigrationManager.tryUpdateCurrentPage(currentPage, event.getArgumentArray())) {
            ++counts.docCount;
        }
    }

    private static boolean tryUpdateCurrentPage(CurrentPage currentPage, Object[] args) {
        if (args.length > 0 && args[0] instanceof Map) {
            Map pageIdentifier = (Map)args[0];
            currentPage.id = DefaultConfluenceMigrationManager.getPageIdentifierField(pageIdentifier, PAGE_ID, Long.class);
            currentPage.originalVersion = DefaultConfluenceMigrationManager.getPageIdentifierField(pageIdentifier, "originalVersion", Long.class);
            currentPage.spaceKey = DefaultConfluenceMigrationManager.getPageIdentifierField(pageIdentifier, "spaceKey", String.class);
            currentPage.pageTitle = DefaultConfluenceMigrationManager.getPageIdentifierField(pageIdentifier, "pageTitle", String.class);
            return currentPage.originalVersion == null || currentPage.originalVersion.equals(currentPage.id);
        }
        return false;
    }

    private static void addEventToCat(LogEvent e, Map<String, List<LogLine<SimpleLog>>> cat, CurrentPage currentPage) {
        String pageIdOrFullName;
        if (cat != null && (pageIdOrFullName = DefaultConfluenceMigrationManager.getPageIdOrFullName(e, currentPage)) != null) {
            List logLines = cat.computeIfAbsent(pageIdOrFullName, k -> new ArrayList());
            logLines.add(currentPage.toLogLine(e));
        }
    }

    private Map<String, List<String>> getPermissionIssues(String root, Collection<String> docs) {
        String wiki = this.getWiki(root);
        HashMap<String, List<String>> permissionIssues = new HashMap<String, List<String>>(2);
        this.putMissingSubjects(wiki, docs, permissionIssues, "groups");
        this.putMissingSubjects(wiki, docs, permissionIssues, "users");
        return permissionIssues;
    }

    private String getWiki(String root) {
        if (StringUtils.isNotEmpty((CharSequence)root)) {
            EntityReference rootRef;
            if (root.startsWith("wiki:")) {
                return root.substring(5);
            }
            String r = root;
            if (r.startsWith("space:")) {
                r = r.substring(6);
            } else if (r.startsWith("document:")) {
                r = r.substring(9);
            }
            if (!r.isEmpty() && (rootRef = this.referenceResolver.resolve((Object)r, EntityType.SPACE, new Object[0]).getRoot()).getType() == EntityType.WIKI) {
                return rootRef.getName();
            }
        }
        return ((XWikiContext)this.contextProvider.get()).getWikiId();
    }

    private void putMissingSubjects(String wiki, Collection<String> docs, Map<String, List<String>> res, String field) {
        try {
            res.put(field, new ArrayList<String>(this.getMissingSubjects(field, wiki, docs)));
        }
        catch (QueryException e) {
            this.logger.error("Could not evaluate missing [{}] in permissions", (Object)field, (Object)e);
        }
    }

    private Set<String> getMissingSubjects(String field, String wiki, Collection<String> docs) throws QueryException {
        Set<String> subjects = this.getSubjects(field, wiki, docs);
        if (!subjects.isEmpty()) {
            List foundSubjects = this.queryManager.createQuery(String.format("select o.name from BaseObject o where o.name in (:refs) and o.className = 'XWiki.XWiki%s'", StringUtils.capitalize((String)field)), "hql").bindValue("refs", subjects).execute();
            subjects.removeIf(foundSubjects::contains);
        }
        return subjects;
    }

    private Set<String> getSubjects(String field, String wiki, Collection<String> docs) throws QueryException {
        TreeSet<String> subjects = new TreeSet<String>();
        this.addSubjects(subjects, wiki, docs, field, "XWiki.XWikiRights");
        this.addSubjects(subjects, wiki, docs, field, "XWiki.XWikiGlobalRights");
        return subjects;
    }

    private void addSubjects(Set<String> subjects, String wiki, Collection<String> docs, String field, String rightObjectName) throws QueryException {
        String optimizedFilter = ((XWikiContext)this.contextProvider.get()).getWikiId().equals(wiki) ? "p.value not in (select o.name from BaseObject o where o.className = 'XWiki.XWiki%3$s') and " : "";
        String queryString = String.format("select distinct p.value from BaseObject obj, LargeStringProperty p where obj.name in (:docs) and p.value <> '' and %4$sobj.className = '%1$s' and p.id.id = obj.id and p.id.name = '%2$s'", rightObjectName, field, StringUtils.capitalize((String)field), optimizedFilter);
        List entries = this.queryManager.createQuery(queryString, "hql").setWiki(wiki).bindValue("docs", docs).execute();
        for (String subjectsWithCommas : entries) {
            subjects.addAll(List.of(subjectsWithCommas.split("\\s*,\\s*")));
        }
    }

    private void addAttachment(String name, Object obj, XWikiDocument document) {
        XWikiAttachment a = new XWikiAttachment(document, name);
        XWikiAttachmentContent content = new XWikiAttachmentContent(a);
        try {
            new ObjectMapper().writeValue(content.getContentOutputStream(), obj);
        }
        catch (IOException e) {
            this.logger.error("Could not save [{}]", (Object)name, (Object)e);
        }
        a.setAttachment_content(content);
        document.setAttachment(a);
    }

    private static String toString(Long id) {
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    private static String getPageIdOrFullName(LogEvent logEvent, CurrentPage currentPage) {
        if (currentPage.ref == null) {
            for (Object arg : logEvent.getArgumentArray()) {
                if (!(arg instanceof Map)) continue;
                return ((Map)arg).get(PAGE_ID).toString();
            }
            return DefaultConfluenceMigrationManager.toString(currentPage.id);
        }
        return currentPage.ref;
    }

    private void persistMacroMap(Map<String, Map<String, Integer>> macroPages) {
        Map<String, Map<String, Object>> macroMap = this.computeMacroMap(macroPages);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        DocumentReference migratedMacrosCountJSONDocRef = new DocumentReference(context.getWikiId(), CONFLUENCE_MIGRATOR_SPACE, "MigratedMacrosCountJSON");
        DocumentReference migratedMacrosDocsJSONDocRef = new DocumentReference(context.getWikiId(), CONFLUENCE_MIGRATOR_SPACE, "MigratedMacrosDocsJSON");
        this.logger.info("Saving the macro usage statistics in [{}] and [{}]", (Object)migratedMacrosCountJSONDocRef, (Object)migratedMacrosDocsJSONDocRef);
        try {
            XWikiDocument macroCountDoc = context.getWiki().getDocument(migratedMacrosCountJSONDocRef, context).clone();
            Map<String, Map<String, Integer>> countMap = this.contentToMap(macroCountDoc, COUNT_MAP_TYPE_REF);
            XWikiDocument macroDocsDoc = context.getWiki().getDocument(migratedMacrosDocsJSONDocRef, context).clone();
            Map<String, Map<String, Set<?>>> docsMap = this.contentToMap(macroDocsDoc, DOCS_MAP_TYPE_REF);
            this.prepareMacroMap(macroMap, countMap, docsMap);
            Map sortedCounts = countMap.entrySet().stream().sorted((o1, o2) -> Integer.compare(((Map)o2.getValue()).getOrDefault(OCCURRENCES_KEY, 0), ((Map)o1.getValue()).getOrDefault(OCCURRENCES_KEY, 0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o1, o2) -> o2, LinkedHashMap::new));
            this.saveMacroData(macroCountDoc, sortedCounts);
            this.saveMacroData(macroDocsDoc, docsMap);
        }
        catch (XWikiException | IOException e) {
            this.logger.error("Failed to save the macro usage statistics", e);
        }
    }

    private <T> void saveMacroData(XWikiDocument d, T data) throws XWikiException, IOException {
        XWikiAttachment attachment = new XWikiAttachment(d, DATA_JSON);
        XWikiAttachmentContent content = new XWikiAttachmentContent(attachment);
        new ObjectMapper().writeValue(content.getContentOutputStream(), data);
        attachment.setAttachment_content(content);
        d.setAttachment(attachment);
        d.setHidden(Boolean.valueOf(true));
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        context.getWiki().saveDocument(d, context);
    }

    private void prepareMacroMap(Map<String, Map<String, Object>> macroMap, Map<String, Map<String, Integer>> occurenceMap, Map<String, Map<String, Set<?>>> pagesMap) {
        for (Map.Entry<String, Map<String, Object>> macroEntry : macroMap.entrySet()) {
            String macroId = macroEntry.getKey();
            Map<String, Object> macroSpacesData = macroEntry.getValue();
            for (Map.Entry<String, Object> macroData : macroSpacesData.entrySet()) {
                String spaceKey = macroData.getKey();
                Map macroOccurenceMap = occurenceMap.computeIfAbsent(macroId, k -> new HashMap());
                if (macroData.getValue() instanceof Integer) {
                    int occurrences = macroOccurenceMap.getOrDefault(OCCURRENCES_KEY, 0);
                    int oldSpaceOccurrences = macroOccurenceMap.getOrDefault(spaceKey, 0);
                    int newSpaceOccurrences = (Integer)macroData.getValue();
                    macroOccurenceMap.put(OCCURRENCES_KEY, occurrences - oldSpaceOccurrences + newSpaceOccurrences);
                    macroOccurenceMap.put(spaceKey, newSpaceOccurrences);
                    continue;
                }
                if (!(macroData.getValue() instanceof Set)) continue;
                Set pages = (Set)macroData.getValue();
                int pagesCount = macroOccurenceMap.getOrDefault(PAGES_KEY, 0);
                int oldPagesCount = macroOccurenceMap.getOrDefault(spaceKey, 0);
                int newPagesCount = pages.size();
                macroOccurenceMap.put(PAGES_KEY, pagesCount - oldPagesCount + newPagesCount);
                macroOccurenceMap.put(spaceKey, newPagesCount);
                pagesMap.computeIfAbsent(macroId, k -> new HashMap()).put(spaceKey, pages);
            }
        }
    }

    private <T> Map<String, T> contentToMap(XWikiDocument doc, TypeReference<Map<String, T>> typeRef) {
        try {
            String dataStr = doc.getContent();
            if (!dataStr.isEmpty()) {
                doc.setContent("");
                return (Map)new ObjectMapper().readValue(dataStr, typeRef);
            }
            XWikiAttachment dataAttachment = doc.getAttachment(DATA_JSON);
            if (dataAttachment != null) {
                InputStream data = dataAttachment.getAttachmentContent((XWikiContext)this.contextProvider.get()).getContentInputStream();
                return (Map)new ObjectMapper().readValue(data, typeRef);
            }
        }
        catch (XWikiException | IOException e) {
            this.logger.warn("Failed to read existing macro usage statistics from [{}]", (Object)doc, (Object)e);
        }
        return new HashMap();
    }

    private Map<String, Map<String, Object>> computeMacroMap(Map<String, Map<String, Integer>> macroPages) {
        HashMap<String, Map<String, Object>> macroMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Integer>> macroPage : macroPages.entrySet()) {
            String page;
            Map<String, Integer> pageMacroCount = macroPage.getValue();
            String space = page.substring(0, (page = macroPage.getKey()).indexOf(46) > -1 ? page.indexOf(46) : page.length() - 1);
            for (Map.Entry<String, Integer> macroEntry : pageMacroCount.entrySet()) {
                Map serializableMacro = macroMap.computeIfAbsent(macroEntry.getKey(), k -> new HashMap());
                String keyCount = String.format("%s_oc", space);
                serializableMacro.put(keyCount, serializableMacro.getOrDefault(keyCount, 0) + macroEntry.getValue());
                String keyPages = String.format("%s_pg", space);
                Object pagesObj = serializableMacro.computeIfAbsent(keyPages, k -> new HashSet());
                if (!(pagesObj instanceof Set)) continue;
                ((Set)pagesObj).add(page);
            }
        }
        return macroMap;
    }

    public void disablePrerequisites() {
        this.prerequisitesManager.disablePrerequisites();
    }

    public void enablePrerequisites() {
        this.prerequisitesManager.enablePrerequisites();
    }

    private static final class DocCounts {
        private long templateCount;
        private long docCount;
        private long revisionCount;

        private DocCounts() {
        }
    }

    private static final class CurrentPage {
        private Long id;
        private Long originalVersion;
        private String spaceKey;
        private String pageTitle;
        private String ref;

        private CurrentPage() {
        }

        private boolean isCurrentRevision() {
            return this.originalVersion == null || this.originalVersion.equals(this.id);
        }

        private <T> LogLine<T> toLogLine(T data) {
            LogLine logLine = new LogLine();
            logLine.data = data;
            logLine.pageId = this.id;
            logLine.originalVersion = this.originalVersion;
            logLine.spaceKey = this.spaceKey;
            logLine.pageTitle = this.pageTitle;
            return logLine;
        }

        private LogLine<SimpleLog> toLogLine(LogEvent e) {
            SimpleLog cl = new SimpleLog();
            cl.args = e.getArgumentArray();
            cl.marker = e.getMarker() == null ? "" : e.getMarker().getName();
            cl.msg = e.getMessage();
            cl.level = e.getLevel().name();
            return this.toLogLine(cl);
        }
    }

    private static final class SimpleLog {
        public String level;
        public String marker;
        public String msg;
        public Object[] args;

        private SimpleLog() {
        }
    }

    private static final class LogLine<T> {
        public Long pageId;
        public Long originalVersion;
        public String spaceKey;
        public String pageTitle;
        public T data;

        private LogLine() {
        }
    }
}

