/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.confluencepro.MigrationExtraDetails;
import com.xwiki.confluencepro.internal.AbstractBatchCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.stability.Unstable;

@Singleton
@Unstable
@Component
public class DefaultBatchCreator
extends AbstractBatchCreator {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final Pattern MIGRATION_BASENAME_PATTERN = Pattern.compile("(?:.*/)?([^/]+?)(?:\\.zip)?$", 2);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CONFLUENCE_MIGRATOR_PRO = "ConfluenceMigratorPro";
    private static final List<String> SPACE = List.of("ConfluenceMigratorPro", "Migrations");
    private static final String WOULD_CREATE = "Would create ";
    @Inject
    private MigrationExtraDetails migrationExtraDetails;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;

    public Map<String, List<String>> createBatch(String batchName, List<String> sources, String inputProperties, String outputProperties, Map<String, String> extraParams) throws JsonProcessingException, XWikiException {
        HashMap<String, List<String>> logs = new HashMap<String, List<String>>();
        ArrayList<Document> migrationDocs = new ArrayList<Document>();
        ArrayList<String> messageList = new ArrayList<String>();
        ObjectNode ownInputProperties = (ObjectNode)OBJECT_MAPPER.readTree(inputProperties);
        ObjectNode ownOutputProperties = (ObjectNode)OBJECT_MAPPER.readTree(outputProperties);
        this.prepareOutputProprties(ownOutputProperties);
        this.processSources(batchName, sources, ownInputProperties, ownOutputProperties, messageList, migrationDocs);
        logs.put("messageList", messageList);
        logs.put("batchPage", this.createBatchPage(batchName, sources, migrationDocs));
        return logs;
    }

    private void processSources(String batchName, List<String> sources, ObjectNode ownInputProperties, ObjectNode ownOutputProperties, List<String> messageList, List<Document> migrationDocs) throws XWikiException, JsonProcessingException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        for (String source : sources) {
            Matcher m = MIGRATION_BASENAME_PATTERN.matcher(source);
            if (m.matches()) {
                String migrationBaseName = m.group(1);
                Document migrationDoc = this.getMigrationDocument(this.buildMigrationBaseName(batchName, migrationBaseName), SPACE);
                Object migrationObject = migrationDoc.getObject("ConfluenceMigratorPro.Code.MigrationClass", true);
                migrationObject.set("extensions", (java.lang.Object)this.migrationExtraDetails.identifyDependencyVersions());
                migrationObject.set("licenseType", (java.lang.Object)this.migrationExtraDetails.identifyLicenseType());
                ownInputProperties.put("source", this.ensureFilePrefix(source));
                migrationObject.set("inputProperties", (java.lang.Object)ownInputProperties.toString());
                migrationObject.set("outputProperties", (java.lang.Object)ownOutputProperties.toString());
                migrationDoc.save();
                messageList.add("Creating " + String.valueOf(migrationDoc.getDocumentReference()));
                migrationDocs.add(migrationDoc);
                continue;
            }
            this.logger.error("Could not create a migration basename for package [{}]", (java.lang.Object)source);
        }
    }

    private List<String> createBatchPage(String batchName, List<String> sources, List<Document> migrationDocs) throws XWikiException {
        LocalDocumentReference batchReference = new LocalDocumentReference(List.of(CONFLUENCE_MIGRATOR_PRO, "ConfluenceBatches", "Batches"), batchName);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiDocument batchPage = context.getWiki().getDocument((EntityReference)batchReference, context);
        Document document = new Document(batchPage, context);
        Object baseObject = document.getObject("ConfluenceMigratorPro.ConfluenceBatches.Code.ConfluenceBatchClass", true);
        baseObject.set("sources", sources);
        baseObject.set("migrations", migrationDocs.stream().map(d -> (String)this.serializer.serialize((EntityReference)d.getDocumentReference(), new java.lang.Object[0])).collect(Collectors.toList()));
        document.save();
        return List.of((String)this.serializer.serialize((EntityReference)batchReference, new java.lang.Object[0]));
    }

    private void prepareOutputProprties(ObjectNode outputProperties) {
        outputProperties.put("onlyLinkMapping", FALSE);
        outputProperties.put("saveLinkMapping", FALSE);
        outputProperties.put("useLinkMapping", TRUE);
    }

    private String ensureFilePrefix(String source) {
        return source.startsWith("file:") ? source : "file://" + source;
    }

    private String buildMigrationBaseName(String batchName, String migrationName) {
        String stringBuilder = "Batch_" + batchName + "__CONTENT__" + migrationName;
        return stringBuilder;
    }
}

