/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xwiki.confluencepro.ConfluenceMigrationPrerequisites;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

@Component(roles={ConfluenceMigrationPrerequisitesManager.class})
@Singleton
public class ConfluenceMigrationPrerequisitesManager {
    private static final String LISTENER_NOTIFICATION_FILTERS = "NotificationsFiltersPreferences-DocumentMovedListener";
    private static final String LISTENER_NOTIFICATION_EMAIL = "Live Notification Email Listener";
    private static final String LISTENER_AUTOMATIC_NOTIFICATION = "AutomaticNotificationsWatchModeListener";
    private static final String LISTENER_NOTIFICATION_PREFILTERING = "Prefiltering Live Notification Email Listener";
    private static final String LISTENER_USER_MENTION = "UserMentionEventListener";
    @Inject
    private ConfluenceMigrationPrerequisites prerequisites;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private Logger logger;
    private final Map<EventListener, Integer> removedListeners = new HashMap<EventListener, Integer>();

    public void enablePrerequisites() {
        this.addListener(LISTENER_AUTOMATIC_NOTIFICATION);
        this.addListener(LISTENER_NOTIFICATION_PREFILTERING);
        this.addListener(LISTENER_NOTIFICATION_FILTERS);
        this.addListener(LISTENER_NOTIFICATION_EMAIL);
        this.addListener(LISTENER_USER_MENTION);
    }

    public void disablePrerequisites() {
        this.logger.info("Clearing user notifications preferences..");
        this.prerequisites.checkCurrentUserNotificationCleanup();
        this.removeListener(LISTENER_AUTOMATIC_NOTIFICATION);
        this.removeListener(LISTENER_NOTIFICATION_EMAIL);
        this.removeListener(LISTENER_NOTIFICATION_FILTERS);
        this.removeListener(LISTENER_NOTIFICATION_PREFILTERING);
        this.removeListener(LISTENER_USER_MENTION);
    }

    private synchronized void removeListener(String listenerName) {
        this.logger.info("Disabling listener [{}]..", (Object)listenerName);
        EventListener listener = this.observationManager.getListener(listenerName);
        if (listener == null && (listener = (EventListener)this.removedListeners.keySet().stream().filter(e -> listenerName.equals(e.getName())).findFirst().orElse(null)) == null) {
            return;
        }
        this.removedListeners.put(listener, this.removedListeners.getOrDefault(listener, 0) + 1);
        if (this.removedListeners.get(listener) == 1) {
            this.observationManager.removeListener(listenerName);
        }
    }

    private synchronized void addListener(String listenerName) {
        this.logger.info("Enabling listener [{}]..", (Object)listenerName);
        EventListener listener = this.removedListeners.keySet().stream().filter(k -> listenerName.equals(k.getName())).findFirst().orElse(null);
        if (listener == null) {
            return;
        }
        int layers = this.removedListeners.get(listener) - 1;
        if (layers <= 0) {
            this.observationManager.addListener(listener);
            this.removedListeners.remove(listener);
        } else {
            this.removedListeners.put(listener, layers);
        }
    }
}

