/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xwiki.confluencepro.ConfluenceMigrationJobRequest;
import com.xwiki.confluencepro.ConfluenceMigrationJobStatus;
import com.xwiki.confluencepro.internal.ConfluenceQuestionManager;
import com.xwiki.confluencepro.internal.SpaceQuestion;
import com.xwiki.pro.internal.resolvers.LinkMappingStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.event.ConfluenceFilteringEvent;
import org.xwiki.contrib.confluence.filter.input.ConfluenceXMLPackage;
import org.xwiki.contrib.confluence.filter.input.LinkMapper;
import org.xwiki.contrib.confluence.filter.internal.input.ConfluenceLinkMappingReceiver;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.job.question.EntitySelection;

@Component
@Named(value="com.xwiki.confluencepro.internal.ConfluenceFilteringListener")
@Singleton
public class ConfluenceFilteringListener
extends AbstractEventListener {
    static final Marker COLLISION_MARKER = MarkerFactory.getMarker((String)"collidingReferences");
    static final String ONLY_LINK_MAPPING = "onlyLinkMapping";
    @Inject
    private JobContext jobContext;
    @Inject
    private LinkMapper linkMapper;
    @Inject
    private Logger logger;
    @Inject
    private LinkMappingStore linkMappingStore;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public ConfluenceFilteringListener() {
        super(ConfluenceFilteringListener.class.getName(), Collections.singletonList(new ConfluenceFilteringEvent()));
    }

    public void onEvent(Event event, Object source, Object data) {
        Job job = this.jobContext.getCurrentJob();
        ConfluenceMigrationJobStatus status = this.getConfluenceMigrationJobStatus(job);
        if (status == null) {
            this.logger.debug("Could not get the job status. Maybe the migration was not run from Confluence Migrator Pro?");
            return;
        }
        ConfluenceXMLPackage confluencePackage = (ConfluenceXMLPackage)data;
        ConfluenceFilteringEvent ev = (ConfluenceFilteringEvent)event;
        ArrayList<String> spaces = new ArrayList<String>(confluencePackage.getSpaceKeys(false));
        for (Long spaceId : ev.getDisabledSpaces()) {
            try {
                spaces.remove(confluencePackage.getSpaceKey(spaceId.longValue()));
            }
            catch (ConfigurationException e) {
                this.logger.error("Failed to disable import for space id [{}]. This is unexpected.", (Object)spaceId, (Object)e);
            }
        }
        status.setSpaces(spaces);
        if (ConfluenceFilteringListener.shouldAskQuestions(status, job, spaces)) {
            ConfluenceFilteringListener.askSpacesQuestion(ev, confluencePackage, status, spaces);
        }
        if (status.isCanceled()) {
            ev.cancel();
        } else if (ConfluenceFilteringListener.isPropertyEnabled(status, ONLY_LINK_MAPPING)) {
            this.updateLinkMappingAndLookForCollisions(this.linkMappingStore);
            ev.cancel();
        } else if (ConfluenceFilteringListener.isInputPropertyEnabled(status, "storeConfluenceDetailsEnabled")) {
            this.linkMappingStore.removeSpaces(status.getSpaces());
            this.updateLinkMappingAndLookForCollisions(null);
        } else if (ConfluenceFilteringListener.isPropertyEnabled(status, "saveLinkMapping")) {
            this.updateLinkMappingAndLookForCollisions(this.linkMappingStore);
        } else {
            this.updateLinkMappingAndLookForCollisions(null);
        }
    }

    private static boolean shouldAskQuestions(ConfluenceMigrationJobStatus status, Job job, Collection<String> spaces) {
        if (spaces.size() < 2) {
            return false;
        }
        if (ConfluenceFilteringListener.isPropertyEnabled(status, "skipQuestions") || ConfluenceFilteringListener.isPropertyEnabled(status, ONLY_LINK_MAPPING)) {
            return false;
        }
        Request request = job.getRequest();
        if (request == null) {
            return true;
        }
        return request.isInteractive();
    }

    private static boolean isPropertyEnabled(ConfluenceMigrationJobStatus jobStatusToAsk, String propertyName) {
        String v = (String)((ConfluenceMigrationJobRequest)jobStatusToAsk.getRequest()).getOutputProperties().get(propertyName);
        return ConfluenceFilteringListener.isTrue(v);
    }

    private static boolean isInputPropertyEnabled(ConfluenceMigrationJobStatus jobStatusToAsk, String propertyName) {
        String v = (String)((ConfluenceMigrationJobRequest)jobStatusToAsk.getRequest()).getInputProperties().get(propertyName);
        return ConfluenceFilteringListener.isTrue(v);
    }

    static boolean isTrue(String v) {
        return "true".equals(v) || "1".equals(v);
    }

    private static void askSpacesQuestion(ConfluenceFilteringEvent event, ConfluenceXMLPackage confluencePackage, ConfluenceMigrationJobStatus jobStatusToAsk, Collection<String> spaces) {
        SpaceQuestion question = new ConfluenceQuestionManager().createAndAskQuestion((CancelableEvent)event, confluencePackage, (JobStatus)jobStatusToAsk);
        for (EntitySelection entitySelection : question.getConfluenceSpaces().keySet()) {
            if (entitySelection.isSelected()) continue;
            String spaceKey = entitySelection.getEntityReference().getName();
            Long spaceId = confluencePackage.getSpaceId(spaceKey);
            event.disableSpace(spaceId.longValue());
            spaces.remove(spaceKey);
        }
    }

    private ConfluenceMigrationJobStatus getConfluenceMigrationJobStatus(Job job) {
        JobStatus jobStatus = job.getStatus();
        while (jobStatus != null) {
            if (jobStatus instanceof ConfluenceMigrationJobStatus) {
                return (ConfluenceMigrationJobStatus)jobStatus;
            }
            jobStatus = ((AbstractJobStatus)jobStatus).getParentJobStatus();
        }
        return null;
    }

    private void updateLinkMappingAndLookForCollisions(LinkMappingStore store) {
        if (store == null) {
            this.logger.info("Looking for collisions\u2026");
        } else {
            this.logger.info("Computing the link mapping and looking for collisions\u2026");
        }
        AtomicReference<String> currentSpace = new AtomicReference<String>();
        HashMap<String, List<String>> reverseMapping = new HashMap<String, List<String>>();
        HashSet<String> collidingReferences = new HashSet<String>();
        HashMap<String, String> spaceByRef = new HashMap<String, String>();
        Session session = store == null ? null : store.beginTransaction();
        MyConfluenceLinkMappingReceiver mapper = new MyConfluenceLinkMappingReceiver(store, currentSpace, session, reverseMapping, collidingReferences, spaceByRef);
        this.linkMapper.getLinkMapping((ConfluenceLinkMappingReceiver)mapper);
        for (String collidingReference : collidingReferences) {
            String spaceKey = (String)spaceByRef.get(collidingReference);
            List pageTitles = (List)reverseMapping.get(collidingReference);
            this.logger.error(COLLISION_MARKER, "Reference [{}] collides in space [{}] for pages [{}]", new Object[]{collidingReference, spaceKey, pageTitles});
        }
        if (session != null) {
            store.endTransaction(true);
        }
    }

    private final class MyConfluenceLinkMappingReceiver
    implements ConfluenceLinkMappingReceiver {
        private final AtomicReference<String> currentSpace;
        private final Session session;
        private final Map<String, List<String>> reverseMapping;
        private final Set<String> collidingReferences;
        private final Map<String, String> spaceByRef;
        private final LinkMappingStore store;

        private MyConfluenceLinkMappingReceiver(LinkMappingStore store, AtomicReference<String> currentSpace, Session session, Map<String, List<String>> reverseMapping, Set<String> collidingReferences, Map<String, String> spaceByRef) {
            this.currentSpace = currentSpace;
            this.session = session;
            this.reverseMapping = reverseMapping;
            this.collidingReferences = collidingReferences;
            this.spaceByRef = spaceByRef;
            this.store = store;
        }

        public void addPage(String spaceKey, long pageId, EntityReference reference) {
            if (!spaceKey.equals(this.currentSpace.get())) {
                this.currentSpace.set(spaceKey);
            }
            String serialized = (String)ConfluenceFilteringListener.this.serializer.serialize(reference, new Object[0]);
            if (this.store != null && this.session != null) {
                this.store.add(this.session, pageId, serialized);
            }
        }

        public void addPage(String spaceKey, String pageTitle, EntityReference reference) {
            List<String> list;
            if (!spaceKey.equals(this.currentSpace.get())) {
                this.currentSpace.set(spaceKey);
            }
            String serialized = (String)ConfluenceFilteringListener.this.serializer.serialize(reference, new Object[0]);
            if (this.store != null && this.session != null) {
                this.store.add(this.session, spaceKey, pageTitle, serialized);
            }
            if ((list = this.reverseMapping.get(serialized)) == null) {
                list = new ArrayList<String>(1);
                this.reverseMapping.put(serialized, list);
            } else {
                this.collidingReferences.add(serialized);
                this.spaceByRef.put(serialized, spaceKey);
            }
            list.add(pageTitle);
        }
    }
}

