/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.confluencepro.ConfluenceMigrationPrerequisites;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

@Component
@Singleton
public class DefaultConfluenceMigrationPrerequisites
implements ConfluenceMigrationPrerequisites {
    private static final String ERROR = "cross";
    private static final String SUCCESS = "check";
    private static final String WARNING = "exclamation";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Logger logger;
    @Inject
    private NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiCfgSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public String checkMemory() {
        long memory = this.getMemory();
        if (this.getXms() >= memory / 2L && this.getXmx() >= memory) {
            return SUCCESS;
        }
        return ERROR;
    }

    public String checkCache() {
        if (this.getCache() >= 5000) {
            return SUCCESS;
        }
        return ERROR;
    }

    public String checkWikiNotifications() {
        if (!((Boolean)this.xwikiPropertiesSource.getProperty("notifications.enabled", (Object)true)).booleanValue() || !((Boolean)this.xwikiPropertiesSource.getProperty("notifications.emails.enabled", (Object)true)).booleanValue()) {
            return SUCCESS;
        }
        return WARNING;
    }

    public String checkCurrentUserNotification() {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        try {
            XWikiDocument userDocument = xcontext.getWiki().getDocument(userReference, xcontext);
            BaseObject autoWatchObj = userDocument.getXObject(this.documentReferenceResolver.resolve((Object)"XWiki.Notifications.Code.AutomaticWatchModeClass", new Object[0]));
            if (autoWatchObj != null && !autoWatchObj.getStringValue("automaticWatchMode").equals("NONE")) {
                return ERROR;
            }
            Collection filters = this.notificationFilterPreferenceManager.getFilterPreferences(userReference);
            for (NotificationFilterPreference filter : filters) {
                if (!filter.isEnabled()) continue;
                return ERROR;
            }
            return SUCCESS;
        }
        catch (XWikiException | NotificationException e) {
            this.logger.error("Could not get notification filter for user [{}]", (Object)userReference, (Object)e);
            return ERROR;
        }
    }

    public String checkListener(String listenerClassName, boolean isMandatory) {
        try {
            List listeners = this.componentManager.getInstanceList(EventListener.class);
            for (EventListener listener : listeners) {
                if (!listener.getClass().getName().contains(listenerClassName)) continue;
                EventListener enabledListener = this.observationManager.getListener(listener.getName());
                if (enabledListener == null) {
                    return SUCCESS;
                }
                if (isMandatory) {
                    return ERROR;
                }
                return WARNING;
            }
        }
        catch (ComponentLookupException e) {
            e.printStackTrace();
        }
        return ERROR;
    }

    public long getMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public String readableSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public long getXms() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        return memoryBean.getHeapMemoryUsage().getInit();
    }

    public long getXmx() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        return memoryBean.getHeapMemoryUsage().getMax();
    }

    public int getCache() {
        return (Integer)this.xwikiCfgSource.getProperty("xwiki.store.cache.capacity", (Object)500);
    }

    public String checkCurrentUserNotificationCleanup() {
        DocumentReference userReference = ((XWikiContext)this.contextProvider.get()).getUserReference();
        try {
            Collection filters = this.notificationFilterPreferenceManager.getFilterPreferences(userReference);
            for (NotificationFilterPreference filter : filters) {
                this.notificationFilterPreferenceManager.deleteFilterPreference(userReference, filter.getId());
            }
            if (this.notificationFilterPreferenceManager.getFilterPreferences(userReference).isEmpty()) {
                return SUCCESS;
            }
        }
        catch (NotificationException e) {
            this.logger.error("Could not clean the notification filters for user [{}]", (Object)userReference, (Object)e);
        }
        return WARNING;
    }
}

