/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xwiki.confluencepro.ConfluenceMigrationJobStatus;
import com.xwiki.confluencepro.internal.SpaceQuestion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.xwiki.contrib.confluence.filter.input.ConfluenceXMLPackage;
import org.xwiki.job.event.status.CancelableJobStatus;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.refactoring.job.question.EntitySelection;

public class ConfluenceQuestionManager {
    public SpaceQuestion createAndAskQuestion(CancelableEvent event, ConfluenceXMLPackage confluencePackage, JobStatus jobStatusToAsk) {
        HashMap<EntitySelection, Map<String, String>> confluenceSpaces = new HashMap<EntitySelection, Map<String, String>>();
        for (Map.Entry space : confluencePackage.getSpacesByKey().entrySet()) {
            EntityReference spaceRef = new EntityReference((String)space.getKey(), EntityType.DOCUMENT);
            HashMap<String, String> additionalInfo = new HashMap<String, String>();
            additionalInfo.put("documentsCount", Integer.toString(((List)confluencePackage.getPages().get(space.getValue())).size()));
            int attachmentsNumber = ((List)confluencePackage.getPages().get(space.getValue())).stream().map(p -> confluencePackage.getAttachments(p.longValue()).size()).reduce(Integer::sum).orElse(0);
            additionalInfo.put("attachmentsCount", Integer.toString(attachmentsNumber));
            try {
                additionalInfo.put("name", confluencePackage.getSpaceProperties(((Long)space.getValue()).longValue()).getString("name", ""));
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            confluenceSpaces.put(new EntitySelection(spaceRef), additionalInfo);
        }
        return this.createAndAskQuestion(event, confluenceSpaces, jobStatusToAsk);
    }

    private SpaceQuestion createAndAskQuestion(CancelableEvent event, Map<EntitySelection, Map<String, String>> confluenceSpaces, JobStatus jobStatusToAsk) {
        SpaceQuestion question = new SpaceQuestion(confluenceSpaces);
        if (jobStatusToAsk instanceof ConfluenceMigrationJobStatus) {
            ((ConfluenceMigrationJobStatus)jobStatusToAsk).addAskedQuestion(jobStatusToAsk.getRequest().getId(), (Object)question);
        }
        question.unselectAll();
        if (jobStatusToAsk != null && jobStatusToAsk.getRequest() != null && jobStatusToAsk.getRequest().isInteractive()) {
            try {
                boolean ack = jobStatusToAsk.ask((Object)question, 1L, TimeUnit.DAYS);
                if (((CancelableJobStatus)jobStatusToAsk).isCanceled()) {
                    event.cancel();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            question.selectAll();
        }
        return question;
    }
}

