/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xwiki.confluencepro.internal.ConfluenceObjectsOnlyInstanceOutputFilterStreamDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.output.OutputFilterStream;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.properties.ConverterManager;

@Component
@Named(value="confluence+objectsonly")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ConfluenceObjectsOnlyInstanceOutputFilterStream
implements OutputFilterStream,
EntityOutputFilterStream<Object>,
OutputFilterStreamFactory {
    protected static final String ROLEHINT = "confluence+objectsonly";
    private static final String WEB_PREFERENCES = "WebPreferences";
    private static final String WEB_HOME = "WebHome";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> documentEntityResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentStringResolver;
    @Inject
    private ConverterManager converter;
    private boolean enabled = true;
    private EntityReference currentEntityReference;
    private BaseObject currentObject;
    private List<BaseObject> currentObjects = new ArrayList<BaseObject>();
    private DocumentInstanceOutputProperties properties;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeResolver;

    public Object getFilter() {
        return this;
    }

    public Object getEntity() {
        return null;
    }

    public void setEntity(Object entity) {
    }

    public void setProperties(DocumentInstanceOutputProperties properties) {
        this.properties = properties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    private EntityReference getDefaultDocumentReference() {
        if (this.properties != null && this.properties.getDefaultReference() != null) {
            return this.properties.getDefaultReference();
        }
        return null;
    }

    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiClass(FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiClass(FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
    }

    public void onWikiClassPropertyField(String name, String value, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWikiDocumentRevision(String revision, FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiDocumentRevision(String revision, FilterEventParameters parameters) throws FilterException {
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = new EntityReference(name, EntityType.WIKI, this.currentEntityReference);
    }

    public void endWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = new EntityReference(name, EntityType.SPACE, this.currentEntityReference);
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = new EntityReference(name, EntityType.DOCUMENT, this.currentEntityReference);
        this.currentObjects.clear();
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        if (!this.currentObjects.isEmpty()) {
            XWikiDocument doc = null;
            EntityReference docRef = this.currentEntityReference;
            if (!WEB_PREFERENCES.equals(docRef.getName()) && !WEB_HOME.equals(docRef.getName())) {
                EntityReference spaceRef = new EntityReference(this.currentEntityReference.getName(), EntityType.SPACE, this.currentEntityReference.getParent());
                docRef = new EntityReference(WEB_HOME, EntityType.DOCUMENT, spaceRef);
            }
            try {
                doc = ((XWikiContext)this.contextProvider.get()).getWiki().getDocument(docRef, (XWikiContext)this.contextProvider.get());
            }
            catch (XWikiException e) {
                this.logger.error("Could not get document [{}]", (Object)docRef, (Object)e);
            }
            if (doc != null) {
                for (BaseObject o : this.currentObjects) {
                    doc.removeXObjects(o.getXClassReference());
                }
                for (BaseObject o : this.currentObjects) {
                    doc.addXObject(o);
                }
                try {
                    ((XWikiContext)this.contextProvider.get()).getWiki().saveDocument(doc, (XWikiContext)this.contextProvider.get());
                    this.logger.info("Saved document [{}]", (Object)docRef);
                }
                catch (XWikiException e) {
                    this.logger.error("Could not save document [{}]", (Object)docRef, (Object)e);
                }
            }
            this.currentObjects.clear();
        }
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    private <T> T get(Type type, String key, FilterEventParameters parameters, T def) {
        return this.get(type, key, parameters, def, true, true);
    }

    private <T> T get(Type type, String key, FilterEventParameters parameters, T def, boolean replaceNull, boolean convert) {
        if (parameters == null) {
            return def;
        }
        if (!parameters.containsKey((Object)key)) {
            return def;
        }
        Object value = parameters.get((Object)key);
        if (value == null) {
            return (T)(replaceNull ? def : null);
        }
        if (TypeUtils.isInstance((Object)value, (Type)type)) {
            return (T)value;
        }
        return (T)(convert ? this.converter.convert(type, value) : value);
    }

    private int getInt(String key, FilterEventParameters parameters, int def) {
        return this.get(Integer.TYPE, key, parameters, def);
    }

    private DocumentReference getDocumentReference(String key, FilterEventParameters parameters, DocumentReference def) {
        DocumentReference reference = this.get((Type)((Object)Object.class), key, parameters, (Object)def, false, false);
        if (reference != null && !(reference instanceof DocumentReference)) {
            reference = reference instanceof EntityReference ? this.documentEntityResolver.resolve((Object)((EntityReference)reference), new Object[]{this.currentEntityReference}) : this.documentStringResolver.resolve((Object)reference.toString(), new Object[]{this.currentEntityReference});
        }
        return reference;
    }

    private EntityReference getEntityReference(String key, FilterEventParameters parameters, EntityReference def) {
        EntityReference reference = this.get((Type)((Object)Object.class), key, parameters, (Object)def, false, false);
        if (reference != null && !(reference instanceof EntityReference)) {
            reference = this.relativeResolver.resolve((Object)reference.toString(), EntityType.DOCUMENT, new Object[0]);
        }
        return reference;
    }

    private String getString(String key, FilterEventParameters parameters, String def) {
        return this.get((Type)((Object)String.class), key, parameters, (Object)def);
    }

    public void beginWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        if (name == null) {
            return;
        }
        this.currentEntityReference = new EntityReference(name, EntityType.OBJECT, this.currentEntityReference);
        this.currentObject = new BaseObject();
        if (parameters.containsKey((Object)"name")) {
            this.currentObject.setDocumentReference(this.getDocumentReference("name", parameters, null));
        }
        int number = this.getInt("number", parameters, -1);
        EntityReference classReference = this.getEntityReference("class_reference", parameters, null);
        if (classReference == null) {
            BaseObjectReference reference = new BaseObjectReference(this.currentEntityReference);
            classReference = reference.getXClassReference();
            if (number < 0 && reference.getObjectNumber() != null) {
                number = reference.getObjectNumber();
            }
        }
        this.currentObject.setXClassReference(classReference);
        this.currentObject.setNumber(number);
        this.currentObject.setGuid(this.getString("guid", parameters, null));
    }

    public void endWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        if (this.currentObject != null) {
            this.currentObjects.add(this.currentObject);
            this.currentObject = null;
        }
        if (this.currentEntityReference.getType() == EntityType.OBJECT) {
            this.currentEntityReference = this.currentEntityReference.getParent();
        }
    }

    public void onWikiObjectProperty(String name, Object value, FilterEventParameters parameters) throws FilterException {
        if (this.currentObject != null) {
            this.currentObject.set(name, value, (XWikiContext)this.contextProvider.get());
        }
    }

    public FilterStreamType getType() {
        return null;
    }

    public FilterStreamDescriptor getDescriptor() {
        return new ConfluenceObjectsOnlyInstanceOutputFilterStreamDescriptor();
    }

    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        return null;
    }

    public OutputFilterStream createOutputFilterStream(Map<String, Object> properties) throws FilterException {
        return this;
    }

    public void close() throws IOException {
    }
}

