/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xwiki.confluencepro.ConfluenceMigrationJobRequest;
import com.xwiki.confluencepro.ConfluenceMigrationJobStatus;
import com.xwiki.confluencepro.ConfluenceMigrationManager;
import com.xwiki.licensing.LicenseType;
import com.xwiki.licensing.Licensor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.job.FilterStreamConverterJobRequest;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.Job;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.CancelableJobStatus;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="confluence.migration")
public class ConfluenceMigrationJob
extends AbstractJob<ConfluenceMigrationJobRequest, ConfluenceMigrationJobStatus>
implements GroupedJob {
    public static final String JOBTYPE = "confluence.migration";
    private static final String CONFLUENCE_XML_ROLEHINT = "confluence+xml";
    private static final String XWIKI_INSTANCE_ROLEHINT = "xwiki+instance";
    private static final String FILTER_CONVERTER_ROLEHINT = "filter.converter";
    private static final String FALSE = "false";
    private static final int TRIAL_PAGE_COUNT = 30;
    private static final String MAX_PAGE_COUNT = "maxPageCount";
    private static final String SOURCE = "source";
    private static final JobGroupPath GROUP = new JobGroupPath(Arrays.asList("confluencemigratorpro", "migration"));
    @Inject
    @Named(value="confluence+xml")
    private InputFilterStreamFactory inputFilterStreamFactory;
    @Inject
    @Named(value="xwiki+instance")
    private OutputFilterStreamFactory outputFilterStreamFactory;
    @Inject
    @Named(value="filter.converter")
    private Provider<Job> filterJobProvider;
    @Inject
    private ConfluenceMigrationManager migrationManager;
    @Inject
    private Provider<Licensor> licensorProvider;
    @Inject
    private QueryManager queryManager;
    private ConfluenceMigrationJobStatus jobStatus;

    public String getType() {
        return JOBTYPE;
    }

    protected ConfluenceMigrationJobStatus createNewStatus(ConfluenceMigrationJobRequest request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        this.jobStatus = new ConfluenceMigrationJobStatus(request, currentJobStatus, this.observationManager, this.loggerManager);
        return this.jobStatus;
    }

    protected void runInternal() throws InterruptedException {
        boolean rightOnly = this.isGeneralParameterEnabled("rightOnly");
        boolean attachmentsOnly = this.isGeneralParameterEnabled("attachmentsOnly");
        this.migrationManager.disablePrerequisites();
        Map<String, Object> inputProperties = this.getFilterInputProperties();
        Map<String, Object> outputProperties = this.getFilterOutputProperties();
        String outputStreamRoleHint = rightOnly ? "confluence+objectsonly" : (attachmentsOnly ? "confluence+attachmentsonly" : XWIKI_INSTANCE_ROLEHINT);
        this.maybeReducePageCount(inputProperties);
        FilterStreamConverterJobRequest filterJobRequest = new FilterStreamConverterJobRequest(FilterStreamType.unserialize((String)CONFLUENCE_XML_ROLEHINT), inputProperties, FilterStreamType.unserialize((String)outputStreamRoleHint), outputProperties);
        boolean interactive = !this.isGeneralParameterEnabled("skipQuestions") && !this.isGeneralParameterEnabled("onlyLinkMapping");
        filterJobRequest.setInteractive(interactive);
        ((ConfluenceMigrationJobRequest)this.request).setInteractive(interactive);
        this.progressManager.pushLevelProgress(1, (Object)this);
        this.logger.info("Starting Filter Job");
        this.progressManager.startStep((Object)this);
        Job filterJob = (Job)this.filterJobProvider.get();
        filterJob.initialize((Request)filterJobRequest);
        this.setCancelable(filterJob);
        filterJob.run();
        this.progressManager.popLevelProgress((Object)this);
        this.migrationManager.updateAndSaveMigration((ConfluenceMigrationJobStatus)this.getStatus());
        this.migrationManager.enablePrerequisites();
    }

    private void setCancelable(Job filterJob) {
        JobStatus filterJobStatus = filterJob.getStatus();
        if (filterJobStatus instanceof AbstractJobStatus) {
            ((AbstractJobStatus)filterJobStatus).setCancelable(true);
            this.jobStatus.setFilterJobStatus((CancelableJobStatus)filterJobStatus);
        }
    }

    private void maybeReducePageCount(Map<String, Object> inputProperties) {
        int maxPageCount = ConfluenceMigrationJob.getMaxPageCount((ConfluenceMigrationJobRequest)this.request);
        if (maxPageCount > -1 && maxPageCount <= 30) {
            return;
        }
        Licensor licensor = null;
        try {
            licensor = (Licensor)this.licensorProvider.get();
        }
        catch (Exception e) {
            this.logger.warn("Failed to get the licensor, allowing everything", (Throwable)e);
        }
        if (licensor == null) {
            return;
        }
        String wiki = ((ConfluenceMigrationJobRequest)this.request).getStatusDocumentReference().getWikiReference().getName();
        DocumentReference mainRef = new DocumentReference(wiki, Arrays.asList("ConfluenceMigratorPro", "Code"), "MigrationClass");
        if (!licensor.hasLicensure((EntityReference)mainRef) || licensor.getLicense((EntityReference)mainRef) == null || licensor.getLicense((EntityReference)mainRef).getType().equals((Object)LicenseType.TRIAL)) {
            inputProperties.put(MAX_PAGE_COUNT, 30);
        }
    }

    private static int getMaxPageCount(ConfluenceMigrationJobRequest request) {
        int maxPageCount = -1;
        Object maxPageCountObject = request.getInputProperties().get(MAX_PAGE_COUNT);
        if (maxPageCountObject instanceof String) {
            try {
                maxPageCount = Integer.parseInt((String)maxPageCountObject);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (maxPageCountObject instanceof Integer) {
            maxPageCount = (Integer)maxPageCountObject;
        }
        return maxPageCount;
    }

    private boolean isGeneralParameterEnabled(String parameterName) {
        return "true".equals(((ConfluenceMigrationJobRequest)this.request).getOutputProperties().getOrDefault(parameterName, FALSE));
    }

    private Map<String, Object> getFilterOutputProperties() {
        FilterStreamDescriptor outputDescriptor = this.outputFilterStreamFactory.getDescriptor();
        Map outputProperties = outputDescriptor.getProperties().stream().collect(HashMap::new, (m, v) -> m.put(v.getId(), v.getDefaultValue()), HashMap::putAll);
        for (Map.Entry entry : ((ConfluenceMigrationJobRequest)this.request).getOutputProperties().entrySet()) {
            if (entry.getValue() == null || entry.getValue().toString().isEmpty()) continue;
            outputProperties.put((String)entry.getKey(), entry.getValue());
        }
        return outputProperties;
    }

    private Map<String, Object> getFilterInputProperties() {
        String source;
        FilterStreamDescriptor inputDescriptor = this.inputFilterStreamFactory.getDescriptor();
        Map inputProperties = inputDescriptor.getProperties().stream().collect(HashMap::new, (m, v) -> m.put(v.getId(), v.getDefaultValue()), HashMap::putAll);
        if (((ConfluenceMigrationJobRequest)this.getRequest()).getConfluencePackage() != null) {
            inputProperties.put(SOURCE, ((ConfluenceMigrationJobRequest)this.getRequest()).getConfluencePackage());
        }
        for (Map.Entry entry : ((ConfluenceMigrationJobRequest)this.request).getInputProperties().entrySet()) {
            if (entry.getValue() == null || entry.getValue().toString().isEmpty()) continue;
            inputProperties.put((String)entry.getKey(), entry.getValue());
        }
        String sourceObject = inputProperties.getOrDefault(SOURCE, "");
        if (sourceObject instanceof String && (source = sourceObject).startsWith("/")) {
            inputProperties.put(SOURCE, "file://" + source);
        }
        return inputProperties;
    }

    public JobGroupPath getGroupPath() {
        return GROUP;
    }
}

