/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.doc.ListAttachmentArchive;
import com.xpn.xwiki.internal.filter.output.EntityOutputFilterStream;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xwiki.confluencepro.internal.ConfluenceAttachmentsOnlyInstanceOutputFilterStreamDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.output.OutputFilterStream;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="confluence+attachmentsonly")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ConfluenceAttachmentsOnlyInstanceOutputFilterStream
implements OutputFilterStream,
EntityOutputFilterStream<Object>,
OutputFilterStreamFactory {
    protected static final String ROLEHINT = "confluence+attachmentsonly";
    protected static final Pattern VALID_VERSION = Pattern.compile("\\d*\\.\\d*");
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="user/current")
    private DocumentReferenceResolver<String> userStringResolver;
    @Inject
    @Named(value="user/current")
    private DocumentReferenceResolver<EntityReference> userEntityResolver;
    @Inject
    private Provider<ComponentManager> componentManagerProvider;
    private boolean enabled = true;
    private EntityReference currentEntityReference;
    private XWikiDocument doc;
    private XWikiAttachment currentAttachment;
    private ListAttachmentArchive attachmentArchive;
    private AttachmentVersioningStore archiveStore;

    private AttachmentVersioningStore getAttachmentVersioningStore() throws ComponentLookupException {
        if (this.archiveStore == null && this.currentAttachment != null) {
            if (this.currentAttachment.isArchiveStoreSet()) {
                String hint = Objects.requireNonNullElse(this.currentAttachment.getArchiveStore(), "hibernate");
                this.archiveStore = (AttachmentVersioningStore)((ComponentManager)this.componentManagerProvider.get()).getInstance(AttachmentVersioningStore.class, hint);
            } else {
                this.archiveStore = ((XWikiContext)this.contextProvider.get()).getWiki().getDefaultAttachmentArchiveStore();
                this.currentAttachment.setArchiveStore(this.archiveStore.getHint());
            }
        }
        return this.archiveStore;
    }

    private ListAttachmentArchive getArchive() throws FilterException {
        if (this.currentAttachment == null) {
            return null;
        }
        if (this.attachmentArchive == null) {
            try {
                XWikiContext context = (XWikiContext)this.contextProvider.get();
                XWikiAttachmentArchive archive = this.currentAttachment.getAttachmentArchive(context);
                this.attachmentArchive = archive instanceof ListAttachmentArchive ? (ListAttachmentArchive)archive : new ListAttachmentArchive(Arrays.stream(this.currentAttachment.getVersions()).map(v -> {
                    try {
                        return archive.getRevision(this.currentAttachment, v.toString(), context);
                    }
                    catch (XWikiException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new FilterException((Throwable)e);
            }
        }
        return this.attachmentArchive;
    }

    public Object getFilter() {
        return this;
    }

    public Object getEntity() {
        return null;
    }

    public void setEntity(Object entity) {
    }

    public void setProperties(DocumentInstanceOutputProperties properties) {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
        this.beginWikiDocumentAttachment(name, (InputSource)(content != null ? new DefaultInputStreamInputSource(content) : null), size, parameters);
        this.endWikiDocumentAttachment(name, null, size, parameters);
    }

    public void beginWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        this.initializeDoc();
        if (this.doc == null) {
            return;
        }
        this.currentAttachment = this.doc.getAttachment(name);
        if (this.currentAttachment == null) {
            this.currentAttachment = this.createAttachment(name, content, size, parameters);
            this.doc.setAttachment(this.currentAttachment);
        } else {
            String version = this.getString("revision", parameters, null);
            this.beginWikiAttachmentRevision(version, content, size, parameters);
        }
    }

    private XWikiAttachment createAttachment(String name, InputSource source, Long size, FilterEventParameters parameters) throws FilterException {
        XWikiAttachment attachment = new XWikiAttachment();
        this.fillAttachment(attachment, name, source, size, parameters);
        return attachment;
    }

    private <T> T get(Type type, String key, FilterEventParameters parameters, T def) {
        return this.get(type, key, parameters, def, true);
    }

    private <T> T get(Type type, String key, FilterEventParameters parameters, T def, boolean replaceNull) {
        if (parameters == null) {
            return def;
        }
        if (!parameters.containsKey((Object)key)) {
            return def;
        }
        Object value = parameters.get((Object)key);
        if (value == null) {
            return (T)(replaceNull ? def : null);
        }
        if (TypeUtils.isInstance((Object)value, (Type)type)) {
            return (T)value;
        }
        return null;
    }

    protected String getString(String key, FilterEventParameters parameters, String def) {
        return this.get((Type)((Object)String.class), key, parameters, (Object)def);
    }

    protected Date getDate(String key, FilterEventParameters parameters, Date def) {
        return this.get((Type)((Object)Date.class), key, parameters, (Object)def);
    }

    private String fixVersion(String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return null;
        }
        if (VALID_VERSION.matcher(version).matches()) {
            return version;
        }
        if (NumberUtils.isDigits((String)version)) {
            return version + ".1";
        }
        this.logger.warn("Failed to set a proper revision number from version [{}]", (Object)version);
        return null;
    }

    private void setVersion(XWikiAttachment attachment, FilterEventParameters parameters) {
        String version;
        String revision;
        if (parameters.containsKey((Object)"revision") && (revision = this.fixVersion(version = this.getString("revision", parameters, null))) != null) {
            attachment.setVersion(revision);
        }
    }

    protected DocumentReference getUserDocumentReference(String key, FilterEventParameters parameters) {
        DocumentReference userReference = null;
        DocumentReference reference = this.get((Type)((Object)Object.class), key, parameters, null, false);
        if (reference != null && !(reference instanceof DocumentReference)) {
            userReference = this.toUserDocumentReference(reference);
        }
        return userReference;
    }

    protected DocumentReference toUserDocumentReference(Object reference) {
        DocumentReference userDocumentReference = reference instanceof EntityReference ? this.userEntityResolver.resolve((Object)((EntityReference)reference), new Object[]{this.currentEntityReference != null ? this.currentEntityReference.extractReference(EntityType.WIKI) : null}) : this.userStringResolver.resolve((Object)reference.toString(), new Object[]{this.currentEntityReference != null ? this.currentEntityReference.extractReference(EntityType.WIKI) : null});
        if (userDocumentReference != null && userDocumentReference.getName().equals("XWikiGuest")) {
            userDocumentReference = null;
        }
        return userDocumentReference;
    }

    private void fillAttachment(XWikiAttachment attachment, String name, InputSource source, Long size, FilterEventParameters parameters) throws FilterException {
        attachment.setFilename(name);
        if (size != null) {
            attachment.setLongSize(size.longValue());
        }
        attachment.setMimeType(this.getString("mimetype", parameters, null));
        attachment.setCharset(this.getString("charset", parameters, null));
        this.fillAttachmentContent(attachment, source);
        attachment.setAuthorReference(this.getUserDocumentReference("revision_author", parameters));
        this.setVersion(attachment, parameters);
        attachment.setComment(this.getString("revision_comment", parameters, ""));
        attachment.setDate(this.getDate("revision_date", parameters, new Date()));
        attachment.setMetaDataDirty(false);
    }

    private void fillAttachmentContent(XWikiAttachment attachment, InputSource source) throws FilterException {
        block10: {
            if (source != null) {
                if (source instanceof InputStreamInputSource) {
                    try (InputStreamInputSource streamSource = (InputStreamInputSource)source;){
                        attachment.setContent(streamSource.getInputStream());
                        break block10;
                    }
                    catch (IOException e) {
                        throw new FilterException("Failed to set attachment content", (Throwable)e);
                    }
                }
                throw new FilterException("Unsupported input stream type [" + String.valueOf(source.getClass()) + "] for the attachment content");
            }
        }
    }

    private void initializeDoc() throws FilterException {
        if (this.currentEntityReference == null || this.currentEntityReference.getType() != EntityType.DOCUMENT) {
            return;
        }
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            this.doc = context.getWiki().getDocument(this.currentEntityReference, context);
        }
        catch (XWikiException e) {
            throw new FilterException("Failed to load document [" + String.valueOf(this.currentEntityReference) + "]", (Throwable)e);
        }
    }

    public void endWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) {
        this.currentAttachment = null;
        this.archiveStore = null;
        this.attachmentArchive = null;
    }

    public void beginWikiAttachmentRevision(String version, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        if (this.currentAttachment == null || !this.shouldPushRevision(version)) {
            return;
        }
        ListAttachmentArchive archive = this.getArchive();
        if (archive == null) {
            this.logger.warn("Could not get the attachment archive for [{}]", (Object)this.currentAttachment.getFilename());
            return;
        }
        try {
            archive.add(this.createAttachment(this.currentAttachment.getFilename(), content, size, parameters));
            AttachmentVersioningStore attachmentVersioningStore = this.getAttachmentVersioningStore();
            if (attachmentVersioningStore == null) {
                this.logger.warn("Could not get the attachment archive store for [{}]", (Object)this.currentAttachment.getFilename());
                return;
            }
            attachmentVersioningStore.saveArchive((XWikiAttachmentArchive)archive, (XWikiContext)this.contextProvider.get(), true);
        }
        catch (XWikiException | ComponentLookupException e) {
            throw new FilterException(e);
        }
    }

    private boolean shouldPushRevision(String version) throws FilterException {
        XWikiAttachment attachmentRevision;
        String revision = this.fixVersion(version);
        if (revision == null) {
            return false;
        }
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        try {
            attachmentRevision = this.currentAttachment.getAttachmentRevision(revision, xcontext);
        }
        catch (XWikiException e) {
            throw new FilterException((Throwable)e);
        }
        return attachmentRevision == null;
    }

    public void endWikiAttachmentRevision(String version, InputSource content, Long size, FilterEventParameters parameters) {
    }

    public void beginWikiClass(FilterEventParameters parameters) {
    }

    public void endWikiClass(FilterEventParameters parameters) {
    }

    public void beginWikiClassProperty(String name, String type, FilterEventParameters parameters) {
    }

    public void endWikiClassProperty(String name, String type, FilterEventParameters parameters) {
    }

    public void onWikiClassPropertyField(String name, String value, FilterEventParameters parameters) {
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) {
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) {
    }

    public void beginWikiDocumentRevision(String revision, FilterEventParameters parameters) {
    }

    public void endWikiDocumentRevision(String revision, FilterEventParameters parameters) {
    }

    public void beginWiki(String name, FilterEventParameters parameters) {
        this.currentEntityReference = new EntityReference(name, EntityType.WIKI, this.currentEntityReference);
    }

    public void endWiki(String name, FilterEventParameters parameters) {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) {
        this.currentEntityReference = new EntityReference(name, EntityType.SPACE, this.currentEntityReference);
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) {
        this.currentEntityReference = this.currentEntityReference.getParent();
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) {
        this.currentEntityReference = new EntityReference(name, EntityType.DOCUMENT, this.currentEntityReference);
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentEntityReference = this.currentEntityReference.getParent();
        this.doc = null;
    }

    public void beginWikiObject(String name, FilterEventParameters parameters) {
    }

    public void endWikiObject(String name, FilterEventParameters parameters) {
    }

    public void onWikiObjectProperty(String name, Object value, FilterEventParameters parameters) {
    }

    public FilterStreamType getType() {
        return null;
    }

    public FilterStreamDescriptor getDescriptor() {
        return new ConfluenceAttachmentsOnlyInstanceOutputFilterStreamDescriptor();
    }

    public Collection<Class<?>> getFilterInterfaces() {
        return null;
    }

    public OutputFilterStream createOutputFilterStream(Map<String, Object> properties) {
        return this;
    }

    public void close() throws IOException {
    }
}

