/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;

@Component(hints={"view-file", "viewfile", "viewdoc", "viewppt", "viewxls", "viewpdf", "excel"})
@Singleton
public class ViewFileMacroConverter
extends AbstractMacroConverter {
    static final String VIEW_FILE = "view-file";
    private static final String NAME = "name";

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return VIEW_FILE;
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        HashMap<String, String> parameters = new HashMap<String, String>(4);
        parameters.put("display", VIEW_FILE.equals(confluenceId) ? "thumbnail" : "full");
        String filename = confluenceParameters.get("att--filename");
        if (StringUtils.isEmpty((CharSequence)filename)) {
            filename = confluenceParameters.get(NAME);
        }
        if (StringUtils.isEmpty((CharSequence)filename)) {
            filename = confluenceParameters.get("file");
            if (filename != null && filename.startsWith("^")) {
                filename = filename.substring(1);
            } else {
                throw new RuntimeException("view-file like macro [" + confluenceId + "]'s file parameter doesn't start with the '^' character, don't know how to convert this. Killing the macro conversion.");
            }
        }
        if (StringUtils.isEmpty((CharSequence)filename)) {
            throw new RuntimeException("Missing file name in viewfile-like macro [" + confluenceId + "], killing the macro conversion.");
        }
        parameters.put(NAME, filename);
        ViewFileMacroConverter.retrieveParameter(confluenceParameters, parameters, "height");
        ViewFileMacroConverter.retrieveParameter(confluenceParameters, parameters, "width");
        ViewFileMacroConverter.retrieveParameter(confluenceParameters, parameters, "page");
        ViewFileMacroConverter.retrieveParameter(confluenceParameters, parameters, "exportFileDelimiter");
        return parameters;
    }

    private static void retrieveParameter(Map<String, String> confluenceParameters, Map<String, String> parameters, String key) {
        String v = confluenceParameters.get(key);
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            parameters.put(key, v);
        }
    }
}

