/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
@Named(value="userlister")
public class UserListerMacroConverter
extends AbstractMacroConverter {
    private static final String GROUPS = "groups";
    private static final String USERS = "users";
    @Inject
    @Named(value="group")
    private EntityReferenceResolver<String> referenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> serializer;

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "userList";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        this.markHandledParameter(confluenceParameters, GROUPS, true);
        this.markHandledParameter(confluenceParameters, USERS, true);
        HashMap<String, String> parameters = new HashMap<String, String>(confluenceParameters.size());
        ArrayList<String> groupList = new ArrayList<String>();
        for (Map.Entry<String, String> p : confluenceParameters.entrySet()) {
            String key = p.getKey();
            String value = p.getValue();
            if (key.equals(GROUPS)) {
                value = this.convertGroupsParameter(p, groupList);
            }
            parameters.put(key, value);
        }
        return parameters;
    }

    private String convertGroupsParameter(Map.Entry<String, String> p, List<String> groupList) {
        for (String group : p.getValue().split("\\s*,\\s*")) {
            if (group.equals("*")) {
                groupList.clear();
                break;
            }
            String groupName = group.startsWith("site-admins") || group.startsWith("confluence-admins") || group.equals("administrators") ? "XWikiAdminGroup" : (group.startsWith("site-users") || group.startsWith("confluence-users") || group.equals(USERS) ? "XWikiAllGroup" : group);
            if (groupName.isEmpty()) continue;
            EntityReference reference = this.referenceResolver.resolve((Object)groupName, EntityType.DOCUMENT, new Object[0]);
            groupList.add((String)this.serializer.serialize(reference, new Object[0]));
        }
        String value = String.join((CharSequence)",", groupList);
        return value;
    }
}

