/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import com.xwiki.date.DateMacroConfiguration;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.input.ConfluenceConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
@Named(value="tasks-report-macro")
public class TasksReportMacroConverter
extends AbstractMacroConverter {
    private static final String PARAMETER_DUEDATE = "duedate";
    private static final String PARAMETER_PAGES = "pages";
    private static final String PARAMETER_SORT_BY = "sortBy";
    private static final String PARAMETER_COLUMNS = "columns";
    private static final String PARAMETER_ASSIGNEES = "assignees";
    private static final String PARAMETER_STATUS = "status";
    private static final String PARAMETER_OWNER = "owner";
    private static final String PARAMETER_VALUE_INCOMPLETE = "incomplete";
    private static final String EMPTY_STRING = "";
    private static final String DELIMITER_REGEX = "\\s*,\\s*";
    private static final String DELIMITER = ",";
    private static final String PARAMETER_ASSIGNEE = "assignee";
    private static final Map<String, String> COLUMN_MAP = Map.of("description", "name", "duedate", "duedate", "assignee", "assignee", "location", "owner", "completedate", "completeDate");
    @Inject
    private Logger logger;
    @Inject
    private ConfluenceConverter converter;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DateMacroConfiguration dateMacroConfiguration;

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "task-report";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        String confluenceDate;
        HashMap<String, String> xwikiParams = new HashMap<String, String>();
        ArrayList<String> pagesFilter = new ArrayList<String>();
        Arrays.stream(confluenceParameters.getOrDefault(PARAMETER_PAGES, EMPTY_STRING).split(DELIMITER_REGEX)).filter(pageId -> !pageId.isEmpty()).map(pageId -> this.converter.convertDocumentReference(Long.parseLong(pageId), false)).map(pageRef -> (String)this.serializer.serialize(pageRef, new Object[0])).forEach(pagesFilter::add);
        pagesFilter.addAll(Arrays.asList(confluenceParameters.getOrDefault("spaces", EMPTY_STRING).split(DELIMITER_REGEX)));
        if (!pagesFilter.isEmpty()) {
            xwikiParams.put(PARAMETER_PAGES, String.join((CharSequence)DELIMITER, pagesFilter));
        }
        xwikiParams.compute("tags", (a, b) -> (String)confluenceParameters.get("labels"));
        xwikiParams.compute(PARAMETER_STATUS, (a, b) -> confluenceParameters.getOrDefault(PARAMETER_STATUS, PARAMETER_VALUE_INCOMPLETE).equals(PARAMETER_VALUE_INCOMPLETE) ? "InProgress" : "Done");
        xwikiParams.compute("reporters", (a, b) -> (String)confluenceParameters.get("creators"));
        xwikiParams.compute(PARAMETER_ASSIGNEES, (a, b) -> (String)confluenceParameters.get(PARAMETER_ASSIGNEES));
        String sortBy = confluenceParameters.getOrDefault(PARAMETER_SORT_BY, PARAMETER_DUEDATE);
        if (sortBy.equals("page title")) {
            sortBy = PARAMETER_OWNER;
        }
        xwikiParams.put(PARAMETER_SORT_BY, sortBy);
        xwikiParams.compute("limit", (a, b) -> (String)confluenceParameters.get("pageSize"));
        List colList = Arrays.stream(confluenceParameters.getOrDefault(PARAMETER_COLUMNS, EMPTY_STRING).split(DELIMITER_REGEX)).map(column -> COLUMN_MAP.getOrDefault(column, EMPTY_STRING)).filter(column -> !column.isEmpty()).collect(Collectors.toList());
        if (!colList.isEmpty()) {
            xwikiParams.put(PARAMETER_COLUMNS, String.join((CharSequence)DELIMITER, colList));
        }
        if (!(confluenceDate = confluenceParameters.getOrDefault("createddateFrom", EMPTY_STRING)).isEmpty()) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
                Date date = simpleDateFormat.parse(confluenceDate);
                simpleDateFormat = new SimpleDateFormat(this.dateMacroConfiguration.getStorageDateFormat());
                xwikiParams.put("createdAfter", simpleDateFormat.format(date));
            }
            catch (Exception e) {
                this.logger.warn("Failed to produce the createdAfter parameter of macro task-report", (Throwable)e);
            }
        }
        return xwikiParams;
    }
}

