/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.input.ConfluenceConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;

@Component(hints={"hide-if", "show-if"})
@Singleton
public class ShowIfHideIfMacroConverter
extends AbstractMacroConverter {
    private static final String LIST_ITEM_PARAM_SEPARATOR = ",";
    private static final String GROUP_ID_PARAM = "groupIds";
    private static final String GROUP_PARAM = "group";
    private static final String GROUPS_PARAM = "groups";
    private static final String SPECIAL_USERNAME_PARAM = "specialUsername";
    private static final String SPECIAL_PARAM = "special";
    private static final String AUTHENTICATION_TYPE_PARAM = "authenticationType";
    private static final String DISPLAY_PARAM_VALUE_PRINTABLE = "printable";
    @Inject
    private ConfluenceConverter converter;

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(confluenceParameters.size());
        block22: for (Map.Entry<String, String> entry : confluenceParameters.entrySet()) {
            String name = entry.getKey();
            String confluenceValue = entry.getValue();
            String xwikiValue = this.toXWikiParameterValue(name, confluenceValue, confluenceId, confluenceParameters, content);
            switch (name) {
                case "match": {
                    parameters.put("matchUsing", xwikiValue.toUpperCase());
                    continue block22;
                }
                case "user": {
                    if (xwikiValue.charAt(0) == '@') {
                        String value = confluenceValue.substring(1).toUpperCase();
                        parameters.put(AUTHENTICATION_TYPE_PARAM, value);
                        continue block22;
                    }
                    parameters.put("users", xwikiValue);
                    continue block22;
                }
                case "groupIds": {
                    String valueGroupId = Arrays.stream(confluenceValue.split(LIST_ITEM_PARAM_SEPARATOR)).map(i -> {
                        String groupRef = this.converter.convertGroupId(i);
                        return groupRef == null ? i : groupRef;
                    }).collect(Collectors.joining(LIST_ITEM_PARAM_SEPARATOR));
                    parameters.put(GROUPS_PARAM, valueGroupId);
                    continue block22;
                }
                case "group": {
                    String valueGroup = Arrays.stream(confluenceValue.split(LIST_ITEM_PARAM_SEPARATOR)).map(i -> {
                        String groupRef = this.converter.toGroupReference(i);
                        return groupRef == null ? i : groupRef;
                    }).collect(Collectors.joining(LIST_ITEM_PARAM_SEPARATOR));
                    parameters.put(GROUPS_PARAM, valueGroup);
                    continue block22;
                }
                case "specialUsername": {
                    parameters.put(AUTHENTICATION_TYPE_PARAM, xwikiValue.toUpperCase());
                    continue block22;
                }
                case "special": {
                    String valueSpecial = confluenceValue.replace("@", "").toUpperCase();
                    parameters.put(AUTHENTICATION_TYPE_PARAM, valueSpecial);
                    continue block22;
                }
                case "type": {
                    parameters.put("contentType", xwikiValue);
                    continue block22;
                }
                case "display": {
                    if ("word".equalsIgnoreCase(xwikiValue)) {
                        xwikiValue = DISPLAY_PARAM_VALUE_PRINTABLE;
                    } else if ("pdf".equalsIgnoreCase(xwikiValue)) {
                        xwikiValue = DISPLAY_PARAM_VALUE_PRINTABLE;
                    }
                    parameters.put("displayType", xwikiValue.toUpperCase());
                    continue block22;
                }
                case "label": {
                    parameters.put("tags", xwikiValue);
                    continue block22;
                }
            }
            String parameterName = this.toXWikiParameterName(name, confluenceId, confluenceParameters, content);
            parameters.put(parameterName, xwikiValue);
        }
        return parameters;
    }
}

