/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;

@Component
@Singleton
@Named(value="roundrect")
public class RoundRectMacroConvertor
extends AbstractMacroConverter {
    private static final String TITLE = "title";
    private static final String FOOTER = "footer";
    private static final String TITLEBGCOLOR = "titlebgcolor";
    private static final String BGCOLOR = "bgcolor";
    private static final String FOOTERBGCOLOR = "footerbgcolor";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String CLASS = "class";
    @Inject
    private Logger logger;

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "panel";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        HashMap<String, String> xwikiParameters = new HashMap<String, String>();
        Iterator<String> iterator = confluenceParameters.keySet().iterator();
        block20: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "title": {
                    xwikiParameters.put(TITLE, confluenceParameters.get(key));
                    continue block20;
                }
                case "footer": {
                    xwikiParameters.put(FOOTER, confluenceParameters.get(key));
                    continue block20;
                }
                case "titlebgcolor": {
                    xwikiParameters.put("titleBGColor", confluenceParameters.get(key));
                    continue block20;
                }
                case "bgcolor": {
                    xwikiParameters.put("bgColor", confluenceParameters.get(key));
                    continue block20;
                }
                case "footerbgcolor": {
                    xwikiParameters.put("footerBGColor", confluenceParameters.get(key));
                    continue block20;
                }
                case "width": {
                    xwikiParameters.put(WIDTH, confluenceParameters.get(key));
                    continue block20;
                }
                case "height": {
                    xwikiParameters.put(HEIGHT, confluenceParameters.get(key));
                    continue block20;
                }
                case "class": {
                    xwikiParameters.put("classes", confluenceParameters.get(key));
                    continue block20;
                }
            }
            xwikiParameters.put("confluence_" + key, confluenceParameters.get(key));
            this.logger.warn(String.format("Parameter %s is not supported and was converted into confluence_%s.", key, key));
        }
        return xwikiParameters;
    }
}

