/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.Map;
import java.util.TreeMap;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.MacroConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;

@Component(hints={"multi-excerpt-include", "multiexcerpt-include", "multiexcerpt-include-macro", "multiexcerpt-fast-include-block-macro", "multiexcerpt-fast-include-inline-macro"})
@Singleton
public class MultiExcerptIncludeMacroConverter
extends AbstractMacroConverter
implements MacroConverter {
    private static final String INLINE = "inline";
    private static final String BLOCK = "block";
    private static final String TEMPLATE_DATA = "templateData";
    private static final String NAME = "name";
    private static final String TRUE = "true";
    private static final String NOPANEL = "nopanel";
    private static final String FALSE = "false";

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "excerpt-include";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        TreeMap<String, String> p = new TreeMap<String, String>();
        String reference = confluenceParameters.get("page");
        if (reference == null) {
            reference = confluenceParameters.get("PageWithExcerpt");
        }
        if (reference == null) {
            reference = confluenceParameters.get("pageTitle");
        }
        reference = reference == null || reference.isEmpty() ? "WebHome" : reference;
        p.put("0", reference);
        String name = confluenceParameters.get(NAME);
        if (name == null) {
            name = confluenceParameters.get("MultiExcerptName");
        }
        p.put(NAME, name);
        String templateData = confluenceParameters.get(TEMPLATE_DATA);
        if (templateData != null && !templateData.isEmpty()) {
            p.put(TEMPLATE_DATA, templateData);
        }
        this.handleInlineAndPanel(confluenceId, confluenceParameters, content, p);
        return p;
    }

    private void handleInlineAndPanel(String confluenceId, Map<String, String> confluenceParameters, String content, Map<String, String> p) {
        MacroConverter.InlineSupport supportsInlineMode;
        String nopanel = confluenceParameters.get(NOPANEL);
        String addpanel = confluenceParameters.get("addpanel");
        if (StringUtils.isEmpty((CharSequence)nopanel)) {
            String string = nopanel = FALSE.equals(addpanel) ? TRUE : FALSE;
        }
        if (MacroConverter.InlineSupport.YES.equals((Object)(supportsInlineMode = this.supportsInlineMode(confluenceId, confluenceParameters, content)))) {
            p.put(INLINE, TRUE);
            if (StringUtils.isNotEmpty((CharSequence)nopanel)) {
                p.put(NOPANEL, nopanel);
            }
        } else {
            if (MacroConverter.InlineSupport.NO.equals((Object)supportsInlineMode)) {
                p.put(INLINE, FALSE);
            }
            p.put(NOPANEL, TRUE);
        }
    }

    public MacroConverter.InlineSupport supportsInlineMode(String id, Map<String, String> parameters, String content) {
        if (id.contains(BLOCK)) {
            return MacroConverter.InlineSupport.NO;
        }
        if (id.contains(INLINE)) {
            return MacroConverter.InlineSupport.YES;
        }
        return MacroConverter.InlineSupport.MAYBE;
    }
}

