/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import com.xwiki.confluencepro.converters.internal.AbstractTaskConverter;
import com.xwiki.date.DateMacroConfiguration;
import com.xwiki.task.TaskConfiguration;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.input.ConfluenceInputContext;
import org.xwiki.contrib.confluence.filter.internal.input.ConfluenceConverter;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

@Component
@Singleton
@Named(value="tasklist")
public class LegacyTaskListMacroConverter
extends AbstractTaskConverter {
    private static final String PARAM_PRIORITY = "priority";
    private static final String PARAM_LOCKED = "locked";
    private static final String PARAM_CHECKED = "checked";
    private static final String VAL_T = "T";
    private static final String PARAM_ID = "id";
    @Inject
    private TaskConfiguration taskConfiguration;
    @Inject
    private DateMacroConfiguration dateMacroConfiguration;
    @Inject
    private ConfluenceConverter confluenceConverter;
    @Inject
    @Named(value="xwiki/2.1")
    private BlockRenderer blockRenderer;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainParser;
    @Inject
    private ConfluenceInputContext context;
    @Inject
    private Logger logger;
    private Map<Long, Integer> legacyMacrosIdCounter = new HashMap<Long, Integer>();

    public void toXWiki(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline, Listener listener) {
        List<Map<String, String>> taskList = this.getConfluenceTasksFromContent(confluenceContent);
        SimpleDateFormat storageDateFormat = new SimpleDateFormat(this.dateMacroConfiguration.getStorageDateFormat());
        String title = confluenceParameters.remove("title");
        title = title == null || title.isEmpty() ? confluenceParameters.remove("") : title;
        confluenceParameters.remove("promptOnDelete");
        confluenceParameters.remove("enableLocking");
        listener.beginGroup(confluenceParameters);
        this.maybeTraverseTitle(listener, title);
        for (Map<String, String> task : taskList) {
            if (!this.shouldConvertToTaskbox("", confluenceParameters, confluenceContent)) {
                this.toXWikiTask(task, storageDateFormat);
                int refSuffix = this.legacyMacrosIdCounter.getOrDefault(this.context.getCurrentPage(), 0);
                this.legacyMacrosIdCounter.put(this.context.getCurrentPage(), refSuffix + 1);
                task.put("reference", "/Tasks/Task_Legacy_" + refSuffix);
                listener.onMacro("task", task, task.remove("name"), false);
                continue;
            }
            this.toXWikiTaskbox(task);
            listener.onMacro("taskbox", task, task.remove("name"), false);
        }
        listener.endGroup(confluenceParameters);
    }

    private List<Map<String, String>> getConfluenceTasksFromContent(String confluenceContent) {
        ArrayList<Map<String, String>> taskList = new ArrayList<Map<String, String>>();
        for (String line : confluenceContent.split("\n")) {
            if (line.trim().isEmpty() || line.startsWith("||")) continue;
            HashMap<String, String> task = new HashMap<String, String>();
            if (line.startsWith("|")) {
                String[] properties = line.substring(1).split("\\|");
                this.maybePutFromArray(0, properties, task, "status");
                this.maybePutFromArray(1, properties, task, PARAM_PRIORITY);
                this.maybePutFromArray(2, properties, task, PARAM_LOCKED);
                this.maybePutFromArray(3, properties, task, "createDate");
                this.maybePutFromArray(4, properties, task, "completeDate");
                this.maybePutFromArray(5, properties, task, "assignee");
                this.maybePutFromArray(6, properties, task, "name");
            } else {
                task.put("name", line);
            }
            if (task.isEmpty()) continue;
            taskList.add(task);
        }
        return taskList;
    }

    private void maybeTraverseTitle(Listener listener, String title) {
        if (title != null && !title.trim().isEmpty()) {
            try {
                listener.beginParagraph(Collections.emptyMap());
                listener.beginFormat(Format.BOLD, Collections.emptyMap());
                XDOM titleXDOM = this.plainParser.parse((Reader)new StringReader(title));
                List blockToTraverse = titleXDOM.getChildren();
                if (!blockToTraverse.isEmpty() && blockToTraverse.get(0) instanceof ParagraphBlock) {
                    blockToTraverse = ((Block)blockToTraverse.get(0)).getChildren();
                }
                blockToTraverse.forEach(child -> child.traverse(listener));
                listener.endFormat(Format.BOLD, Collections.emptyMap());
                listener.endParagraph(Collections.emptyMap());
            }
            catch (ParseException e) {
                this.logger.warn("Failed to parse the title [{}] of the tasklist confluence macro. Cause: [{}]", (Object)title, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private void maybePutFromArray(int index, String[] properties, Map<String, String> task, String propName) {
        try {
            String property = properties[index];
            if (property.trim().isEmpty()) {
                return;
            }
            task.put(propName, property);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.warn("There is no property at index [{}] in array [{}] when trying to extract tasks from a tasklist confluence macro.", (Object)index, (Object)Arrays.toString(properties));
        }
    }

    private void toXWikiTask(Map<String, String> task, SimpleDateFormat storageDateFormat) {
        task.remove(PARAM_PRIORITY);
        task.remove(PARAM_LOCKED);
        String xwikiStatus = task.getOrDefault("status", "");
        xwikiStatus = xwikiStatus.equals(VAL_T) ? "Done" : this.taskConfiguration.getDefaultInlineStatus();
        task.put("status", xwikiStatus);
        this.maybeUpdateDateProperty("createDate", task, storageDateFormat);
        this.maybeUpdateDateProperty("completeDate", task, storageDateFormat);
        String content = task.getOrDefault("name", "");
        String assignee = task.remove("assignee");
        String mentionMacro = this.getMentionMacro(assignee);
        if (mentionMacro != null && !mentionMacro.trim().isEmpty()) {
            content = String.join((CharSequence)" ", content, mentionMacro);
        }
        task.put("name", content);
    }

    private String getMentionMacro(String assignee) {
        String userRef;
        if (assignee != null && !assignee.trim().isEmpty() && (userRef = this.confluenceConverter.convertUserReference(assignee)) != null) {
            HashMap<String, String> mentionParams = new HashMap<String, String>();
            mentionParams.put("style", "FULL_NAME");
            mentionParams.put("reference", userRef);
            mentionParams.put("anchor", String.join((CharSequence)"-", userRef.replace('.', '-'), "legacy", this.legacyMacrosIdCounter.getOrDefault(this.context.getCurrentPage(), 0).toString()));
            MacroBlock mentionBlock = new MacroBlock("mention", mentionParams, true);
            DefaultWikiPrinter printer = new DefaultWikiPrinter(new StringBuffer());
            this.blockRenderer.render(Collections.singletonList(mentionBlock), (WikiPrinter)printer);
            return printer.toString();
        }
        return null;
    }

    private void maybeUpdateDateProperty(String key, Map<String, String> task, SimpleDateFormat storageDateFormat) {
        try {
            String serializedCreateDate = task.getOrDefault(key, "");
            if (!serializedCreateDate.trim().isEmpty()) {
                Date date = new Date(Long.parseLong(serializedCreateDate.trim()));
                task.put(key, storageDateFormat.format(date));
            }
        }
        catch (NumberFormatException e) {
            this.logger.warn("Failed to parse the date [{}] for the [{}] property.", (Object)task.get(key), (Object)key);
        }
    }

    private void toXWikiTaskbox(Map<String, String> task) {
        String assignee;
        String mentionMacro;
        task.remove(PARAM_PRIORITY);
        task.remove(PARAM_LOCKED);
        task.remove("createDate");
        String content = task.remove("name");
        if (content == null) {
            content = "";
        }
        if ((mentionMacro = this.getMentionMacro(assignee = task.remove("assignee"))) != null) {
            content = String.join((CharSequence)" ", content, mentionMacro);
        }
        task.put("name", content);
        String status = task.remove("status");
        status = VAL_T.equals(status) ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        task.put(PARAM_CHECKED, status);
        int refSuffix = this.legacyMacrosIdCounter.getOrDefault(this.context.getCurrentPage(), 0);
        this.legacyMacrosIdCounter.put(this.context.getCurrentPage(), refSuffix + 1);
        task.put(PARAM_ID, "Legacy" + refSuffix);
    }
}

