/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.input.ConfluenceConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
@Named(value="inc-drawio")
public class IncDrawIoMacroConvertor
extends AbstractMacroConverter {
    @Inject
    private Logger logger;
    @Inject
    private ConfluenceConverter converter;

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "confluence_drawio";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        HashMap<String, String> xwikiParameters = new HashMap<String, String>(confluenceParameters);
        confluenceParameters.forEach((a, b) -> this.markHandledParameter(confluenceParameters, (String)a, true));
        if (confluenceParameters.containsKey("service") || confluenceParameters.containsKey("diagramUrl")) {
            this.logger.warn("The inc-drawio was used with unsupported parameters.");
            return xwikiParameters;
        }
        long pageId = Long.parseLong(confluenceParameters.get("pageId"));
        EntityReference reference = this.converter.convertDocumentReference(pageId, false);
        if (reference != null) {
            String ref = reference.toString().substring(reference.toString().indexOf(" ") + 1);
            xwikiParameters.put("originalDocumentRef", ref);
        }
        xwikiParameters.put("diagramName", confluenceParameters.get("diagramDisplayName"));
        return xwikiParameters;
    }
}

