/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import com.xwiki.confluencepro.converters.internal.AbstractTaskConverter;
import com.xwiki.task.TaskConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
@Named(value="task")
public class TaskMacroConverter
extends AbstractTaskConverter {
    private static final String TASK_STATUS_PARAMETER = "status";
    private static final String TASK_STATUS_COMPLETE = "complete";
    private static final String TASK_ID_PARAMETER = "id";
    private static final String TASK_REFERENCE_PARAMETER = "reference";
    private static final String TASK_REFERENCE_PREFIX = "/Tasks/Task_";
    private static final String TASKBOX_CHECKED_PARAMETER = "checked";
    @Inject
    private TaskConfiguration taskConfiguration;

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        if (this.shouldConvertToTaskbox(confluenceId, confluenceParameters, confluenceContent)) {
            return "checkbox";
        }
        return super.toXWikiId(confluenceId, confluenceParameters, confluenceContent, inline);
    }

    protected String toXWikiContent(String confluenceId, Map<String, String> parameters, String confluenceContent) {
        if (confluenceContent == null) {
            return "";
        }
        String newContent = confluenceContent.replace("(% class=\"placeholder-inline-tasks\" %)", "");
        return newContent.replaceAll("\\s*\n\\s*\n\\s*\\{\\{task", "\n\n{{task").trim();
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.shouldConvertToTaskbox(confluenceId, confluenceParameters, content)) {
            if (confluenceParameters.get(TASK_STATUS_PARAMETER).equals(TASK_STATUS_COMPLETE)) {
                params.put(TASKBOX_CHECKED_PARAMETER, Boolean.TRUE.toString());
            } else {
                params.put(TASKBOX_CHECKED_PARAMETER, Boolean.FALSE.toString());
            }
            params.put(TASK_ID_PARAMETER, confluenceParameters.get(TASK_ID_PARAMETER));
            return params;
        }
        String confluenceStatus = confluenceParameters.get(TASK_STATUS_PARAMETER);
        String xwikiStatus = confluenceStatus.equals(TASK_STATUS_COMPLETE) || confluenceStatus.equals("Done") ? "Done" : this.taskConfiguration.getDefaultInlineStatus();
        String confluenceTaskId = confluenceParameters.get(TASK_ID_PARAMETER);
        String reference = confluenceParameters.get(TASK_REFERENCE_PARAMETER);
        Object xwikiIdParam = confluenceTaskId != null ? TASK_REFERENCE_PREFIX + confluenceTaskId : reference;
        params.put(TASK_STATUS_PARAMETER, xwikiStatus);
        params.put(TASK_REFERENCE_PARAMETER, (String)xwikiIdParam);
        return params;
    }
}

