/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.contrib.confluence.filter.MacroConverter;
import org.xwiki.contrib.confluence.filter.input.ConfluenceInputContext;
import org.xwiki.contrib.confluence.filter.input.ConfluenceInputProperties;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
@Named(value="task-list")
public class TaskListMacroConverter
implements MacroConverter {
    @Inject
    private ConfluenceInputContext context;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public void toXWiki(String id, Map<String, String> parameters, String content, boolean inline, Listener listener) {
        Map<String, String> taskListGroupParams = Collections.singletonMap("class", "task-list");
        listener.beginGroup(taskListGroupParams);
        ConfluenceInputProperties inputProperties = this.context.getProperties();
        Syntax macroContentSyntax = inputProperties == null ? null : inputProperties.getMacroContentSyntax();
        String syntaxId = macroContentSyntax != null ? macroContentSyntax.toIdString() : Syntax.XWIKI_2_1.toIdString();
        try {
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
            XDOM contentXDOM = parser.parse((Reader)new StringReader(StringUtils.defaultString((String)content).trim()));
            contentXDOM.getChildren().forEach(child -> child.traverse(listener));
        }
        catch (ComponentLookupException | ParseException e) {
            new MacroBlock("error", Collections.emptyMap(), String.format("Failed to parse the content of the [%s] macro with the syntax [%s].", id, syntaxId), false).traverse(listener);
        }
        listener.endGroup(taskListGroupParams);
    }
}

