/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.MacroConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;

@Component(hints={"multi-excerpt", "multiexcerpt-fast-block-macro", "multiexcerpt-fast-inline-macro", "multiexcerpt-macro", "multiexcerpt"})
@Singleton
public class MultiExcerptMacroConverter
extends AbstractMacroConverter
implements MacroConverter {
    private static final String ATLASSIAN_MACRO_OUTPUT_TYPE = "atlassian-macro-output-type";
    private static final String HIDDEN = "hidden";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String INLINE = "inline";
    private static final String BLOCK = "block";
    private static final String NAME = "name";

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "excerpt";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        MacroConverter.InlineSupport supportsInlineMode;
        HashMap<String, String> p = new HashMap<String, String>(4);
        String name = confluenceParameters.get(NAME);
        if (name == null) {
            name = confluenceParameters.get("MultiExcerptName");
        }
        p.put(NAME, name);
        if (!FALSE.equals(confluenceParameters.getOrDefault(HIDDEN, FALSE))) {
            p.put(HIDDEN, TRUE);
        }
        if (!FALSE.equals(confluenceParameters.getOrDefault("fallback", FALSE))) {
            p.put("allowUnprivilegedInclude", TRUE);
        }
        if (MacroConverter.InlineSupport.NO.equals((Object)(supportsInlineMode = this.supportsInlineMode(confluenceId, confluenceParameters, content)))) {
            p.put(INLINE, FALSE);
        } else if (MacroConverter.InlineSupport.YES.equals((Object)supportsInlineMode)) {
            p.put(INLINE, TRUE);
        }
        return p;
    }

    public MacroConverter.InlineSupport supportsInlineMode(String id, Map<String, String> parameters, String content) {
        if (id.contains(BLOCK) || "BLOCK".equals(parameters.get(ATLASSIAN_MACRO_OUTPUT_TYPE))) {
            return MacroConverter.InlineSupport.NO;
        }
        if (id.contains(INLINE) || "INLINE".equals(parameters.get(ATLASSIAN_MACRO_OUTPUT_TYPE))) {
            return MacroConverter.InlineSupport.YES;
        }
        return MacroConverter.InlineSupport.MAYBE;
    }
}

