/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.internal.input.ConfluenceConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;
import org.xwiki.rendering.listener.Listener;

@Component
@Singleton
@Named(value="listlabels")
public class ListLabelsMacroConverter
extends AbstractMacroConverter {
    private static final String SPACE_KEY = "spaceKey";
    private static final String EXCLUDED_LABELS = "excludedLabels";
    private static final String SPACES = "spaces";
    @Inject
    private ConfluenceConverter converter;

    public void toXWiki(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline, Listener listener) {
        super.toXWiki("tagList", confluenceParameters, confluenceContent, inline, listener);
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        HashMap<String, String> xwikiParameters = new HashMap<String, String>(2);
        String spaceKey = confluenceParameters.get(SPACE_KEY);
        if (StringUtils.isNotEmpty((CharSequence)spaceKey)) {
            xwikiParameters.put(SPACES, spaceKey);
        } else {
            xwikiParameters.put(SPACES, this.converter.convertSpaceReference("@self"));
        }
        String excludedLabels = confluenceParameters.get(EXCLUDED_LABELS);
        if (StringUtils.isNotEmpty((CharSequence)excludedLabels)) {
            xwikiParameters.put("excludedTags", excludedLabels);
        }
        return xwikiParameters;
    }
}

