/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.converters.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.filter.MacroConverter;
import org.xwiki.contrib.confluence.filter.internal.macros.AbstractMacroConverter;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;

@Component
@Singleton
@Named(value="auibutton")
public class AUIButtonMacroConverter
extends AbstractMacroConverter {
    private static final String URL = "url";
    private static final String ICON = "icon";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_TYPE_DEFAULT = "DEFAULT";
    @Inject
    private IconManager iconManager;
    @Inject
    private Logger logger;

    public String toXWikiId(String confluenceId, Map<String, String> confluenceParameters, String confluenceContent, boolean inline) {
        return "button";
    }

    protected Map<String, String> toXWikiParameters(String confluenceId, Map<String, String> confluenceParameters, String content) {
        String classParam;
        String id;
        String type;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(confluenceParameters.size());
        parameters.put("label", confluenceParameters.get("title"));
        parameters.put(URL, confluenceParameters.get(URL));
        switch (confluenceParameters.get(PARAM_TYPE)) {
            case "standard": {
                type = PARAM_TYPE_DEFAULT;
                break;
            }
            case "primary": {
                type = "PRIMARY";
                break;
            }
            default: {
                type = PARAM_TYPE_DEFAULT;
            }
        }
        parameters.put(PARAM_TYPE, type);
        parameters.put("newTab", confluenceParameters.get("target"));
        String icon = confluenceParameters.get(ICON);
        if (StringUtils.isNotEmpty((CharSequence)icon)) {
            List iconList = List.of();
            try {
                iconList = this.iconManager.getIconNames();
            }
            catch (IconException e) {
                this.logger.error("Can't get icon list", (Throwable)e);
            }
            if (iconList.contains(icon)) {
                parameters.put(ICON, icon);
            } else {
                this.markUnhandledParameterValue(confluenceParameters, ICON);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(id = confluenceParameters.get(ID)))) {
            parameters.put(ID, id);
        }
        if (StringUtils.isNotEmpty((CharSequence)(classParam = confluenceParameters.get(CLASS)))) {
            parameters.put(CLASS, classParam);
        }
        return parameters;
    }

    public MacroConverter.InlineSupport supportsInlineMode(String id, Map<String, String> parameters, String content) {
        return MacroConverter.InlineSupport.YES;
    }
}

