/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.script;

import com.xwiki.confluencepro.ConfluenceMigrationJobRequest;
import com.xwiki.confluencepro.ConfluenceMigrationPrerequisites;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.concurrent.ContextStoreManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="confluenceMigration")
@Singleton
public class ConfluenceMigrationScriptService
implements ScriptService {
    public static final String ROLEHINT = "confluenceMigration";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final Map<String, String> PREFILLED_INPUT_PARAMETERS = Map.of("cleanup", "ASYNC", "storeConfluenceDetailsEnabled", "true", "unprefixedMacros", "info,toc,html,panel,excerpt,expand,contributors,content-report-table,recently-updated,excerpt-include,status,profile-picture,tasks-report-macro,date");
    public static final Map<String, String> PREFILLED_OUTPUT_PARAMETERS = Map.of("saveLinkMapping", "true", "versionPreserved", "true", "stoppedWhenSaveFail", "false");
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private Logger logger;
    @Inject
    private ConfluenceMigrationPrerequisites prerequisites;
    @Inject
    private ContextStoreManager contextStoreManager;

    public Job migrate(DocumentReference documentReference, InputStream confluencePackage, Map<String, Object> inputProperties, Map<String, Object> outputProperties) {
        if (!this.authorization.hasAccess(Right.ADMIN)) {
            return null;
        }
        Job lastJob = this.getLastJob(documentReference);
        if (lastJob != null && lastJob.getStatus().getState().equals((Object)JobStatus.State.RUNNING)) {
            return lastJob;
        }
        ConfluenceMigrationJobRequest jobRequest = new ConfluenceMigrationJobRequest(confluencePackage, documentReference, inputProperties, outputProperties);
        try {
            Map migrationContext = this.contextStoreManager.save(Collections.singletonList("wiki"));
            jobRequest.setContext(migrationContext);
            return this.jobExecutor.execute("confluence.migration", (Request)jobRequest);
        }
        catch (Exception e) {
            this.logger.error("Failed to execute the migration job for [{}].", (Object)documentReference, (Object)e);
            return null;
        }
    }

    public Job getLastJob(DocumentReference documentReference) {
        return this.jobExecutor.getJob(ConfluenceMigrationJobRequest.getJobId(documentReference));
    }

    public String checkMemory() {
        return this.prerequisites.checkMemory();
    }

    public String checkCache() {
        return this.prerequisites.checkCache();
    }

    public String checkWikiNotifications() {
        return this.prerequisites.checkWikiNotifications();
    }

    public String checkCurrentUserNotification() {
        return this.prerequisites.checkCurrentUserNotification();
    }

    public String checkListener(String listenerClassName, boolean isMandatory) {
        return this.prerequisites.checkListener(listenerClassName, isMandatory);
    }

    public String getMemory() {
        return this.prerequisites.readableSize(this.prerequisites.getMemory());
    }

    public String getXms() {
        return this.prerequisites.readableSize(this.prerequisites.getXms());
    }

    public String getXmx() {
        return this.prerequisites.readableSize(this.prerequisites.getXmx());
    }

    public int getCache() {
        return this.prerequisites.getCache();
    }

    public String checkCurrentUserNotificationCleanup() {
        return this.prerequisites.checkCurrentUserNotificationCleanup();
    }

    public Map<String, Map<String, String>> getMutablePrefilledConfiguration() {
        HashMap<String, Map<String, String>> prefilledValues = new HashMap<String, Map<String, String>>(2);
        prefilledValues.put("input", new HashMap<String, String>(PREFILLED_INPUT_PARAMETERS));
        prefilledValues.put("output", new HashMap<String, String>(PREFILLED_OUTPUT_PARAMETERS));
        return prefilledValues;
    }
}

