/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWikiContext;
import com.xwiki.confluencepro.internal.configuration.DefaultConfluenceMigratorProConfiguration;
import com.xwiki.licensing.Licensor;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.stability.Unstable;

@Component(roles={MigrationExtraDetails.class})
@Singleton
@Unstable
public class MigrationExtraDetails {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    @Inject
    private DefaultConfluenceMigratorProConfiguration migratorProConfiguration;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Licensor licensor;

    public String identifyDependencyVersions() throws JsonProcessingException {
        HashMap<String, String> versions = new HashMap<String, String>();
        String wikiName = ((XWikiContext)this.contextProvider.get()).getWikiId();
        for (String extensionID : this.migratorProConfiguration.getExtensionIDs()) {
            InstalledExtension extension = this.installedExtensionRepository.getInstalledExtension(extensionID, "wiki:" + wikiName);
            if (extension == null) continue;
            versions.put(extensionID, String.valueOf(extension.getId().getVersion()));
        }
        return JSON_MAPPER.writeValueAsString(versions);
    }

    public String identifyLicenseType() {
        DocumentReference mainWiki = new DocumentReference(((XWikiContext)this.contextProvider.get()).getMainXWiki(), List.of("ConfluenceMigratorPro", "Code"), "MigrationClass");
        return this.licensor.getLicense((EntityReference)mainWiki).getType().toString();
    }
}

