/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro;

import com.xwiki.confluencepro.script.ConfluenceMigrationScriptService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.xwiki.job.AbstractRequest;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class ConfluenceMigrationJobRequest
extends AbstractRequest {
    private static final long serialVersionUID = 1L;
    private final InputStream confluencePackage;
    private final DocumentReference statusDocumentReference;
    private final Map<String, Object> inputProperties;
    private final Map<String, Object> outputProperties;

    public ConfluenceMigrationJobRequest(InputStream confluencePackage, DocumentReference statusDocumentReference, Map<String, Object> inputProperties, Map<String, Object> outputProperties) {
        this.statusDocumentReference = statusDocumentReference;
        this.confluencePackage = confluencePackage;
        List<String> jobId = ConfluenceMigrationJobRequest.getJobId(statusDocumentReference);
        this.setId(jobId);
        this.inputProperties = Objects.requireNonNullElseGet(inputProperties, HashMap::new);
        this.outputProperties = Objects.requireNonNullElseGet(outputProperties, HashMap::new);
        this.mergeWithDefaultProperties(this.inputProperties, ConfluenceMigrationScriptService.PREFILLED_INPUT_PARAMETERS);
        this.mergeWithDefaultProperties(this.outputProperties, ConfluenceMigrationScriptService.PREFILLED_OUTPUT_PARAMETERS);
    }

    private void mergeWithDefaultProperties(Map<String, Object> inputProperties, Map<String, String> defaults) {
        for (Map.Entry<String, String> d : defaults.entrySet()) {
            String key = d.getKey();
            inputProperties.computeIfAbsent(key, k -> d.getValue());
        }
    }

    public static List<String> getJobId(DocumentReference statusDocumentReference) {
        ArrayList<String> jobId = new ArrayList<String>();
        jobId.add("confluence");
        jobId.add("migration");
        for (EntityReference er : statusDocumentReference.getReversedReferenceChain()) {
            jobId.add(er.getName());
        }
        return jobId;
    }

    public InputStream getConfluencePackage() {
        return this.confluencePackage;
    }

    public DocumentReference getStatusDocumentReference() {
        return this.statusDocumentReference;
    }

    public Map<String, Object> getInputProperties() {
        return this.inputProperties;
    }

    public Map<String, Object> getOutputProperties() {
        return this.outputProperties;
    }
}

