/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.script;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xpn.xwiki.XWikiException;
import com.xwiki.confluencepro.BatchCreator;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="confluenceBatches")
@Singleton
public class BatchesScriptServices
implements ScriptService {
    public static final String ROLEHINT = "confluenceBatches";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Inject
    private BatchCreator batchCreator;

    public String computeBatchSize(List<String> paths) {
        int index;
        double bytes = 0.0;
        for (String path : paths) {
            File file = new File(path);
            bytes += (double)file.length();
        }
        String[] units = new String[]{"Bytes", "KB", "MB", "GB", "TB"};
        for (index = 0; bytes >= 1024.0 && index < units.length - 1; bytes /= 1024.0, ++index) {
        }
        return String.format("%.2f %s", bytes, units[index]);
    }

    public File[] getZips(String path) {
        String batchPath = path.startsWith("file:") ? path.substring(5) : path;
        File folder = new File(batchPath);
        if (folder.isDirectory()) {
            return folder.listFiles();
        }
        return null;
    }

    public String getServerAbsolutePath() {
        return Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    public Map<String, List<String>> createBatch(String batchName, List<String> sources, String inputProperties, String outputProperties, Map<String, String> extraParams) throws JsonProcessingException, XWikiException {
        return this.batchCreator.createBatch(batchName, sources, inputProperties, outputProperties, extraParams);
    }

    public ObjectNode resolveJson(String json) throws JsonProcessingException {
        return (ObjectNode)OBJECT_MAPPER.readTree(json);
    }
}

