/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.confluencepro.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.confluencepro.internal.MigrationFixingStats;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.confluence.resolvers.ConfluenceResolverException;
import org.xwiki.contrib.confluence.resolvers.ConfluenceSpaceKeyResolver;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.model.validation.EntityNameValidation;
import org.xwiki.model.validation.EntityNameValidationManager;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component(roles={MigrationFixingTools.class})
@Singleton
public class MigrationFixingTools {
    private static final Marker UPDATED_MARKER = MarkerFactory.getMarker((String)"confluencemigrationfixer.updated");
    private static final Marker UNCHANGED_MARKER = MarkerFactory.getMarker((String)"confluencemigrationfixer.unchanged");
    private static final TypeReference<Map<String, Object>> INPUT_PROPERTIES_TYPE_REF = new TypeReference<Map<String, Object>>(){};
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    private ConfluenceSpaceKeyResolver spaceKeyResolver;
    @Inject
    private Provider<EntityNameValidationManager> entityNameValidationManagerProvider;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private QueryManager queryManager;

    public void fixDocumentsOfMigration(XWikiDocument migrationDoc, Consumer<XWikiDocument> documentFixer) {
        EntityReference root;
        boolean guess;
        Map<String, Object> inputProperties = this.getInputProperties(migrationDoc);
        if (inputProperties == null) {
            guess = true;
            this.logger.warn("Missing input properties means we could not determine the root space of the migration [{}], will attempt to guess.", (Object)migrationDoc.getDocumentReference());
            root = ((XWikiContext)this.contextProvider.get()).getWikiReference();
        } else {
            guess = false;
            root = this.computeRootSpace(inputProperties, this.resolver);
        }
        List spaces = migrationDoc.getListValue("spaces");
        if (CollectionUtils.isEmpty((Collection)spaces)) {
            this.logger.warn("Migration document [{}]: Could not find any space to handle", (Object)migrationDoc.getDocumentReference());
        }
        EntityNameValidation nameStrategy = ((EntityNameValidationManager)this.entityNameValidationManagerProvider.get()).getEntityReferenceNameStrategy();
        for (String space : spaces) {
            this.logger.info("Browsing documents in space [{}]", (Object)space);
            EntityReference spaceReference = this.computeSpaceReference(space, nameStrategy, guess, root);
            if (spaceReference == null) continue;
            this.fixDocumentsInSpace(spaceReference, documentFixer);
        }
    }

    public void fixDocumentsOfSpaces(List<EntityReference> spaceReferences, Consumer<XWikiDocument> migratedDocFixer) {
        if (CollectionUtils.isNotEmpty(spaceReferences)) {
            int size = spaceReferences.size();
            int n = 0;
            for (EntityReference spaceReference : spaceReferences) {
                this.progressManager.startStep((Object)this);
                this.logger.info("Browsing documents of space [{}] ({}/{})", new Object[]{spaceReference, ++n, size});
                this.fixDocumentsInSpace(spaceReference, migratedDocFixer);
                this.progressManager.endStep((Object)this);
            }
        }
    }

    public void fixDocuments(MigrationFixingStats s, List<EntityReference> migrationReferences, List<EntityReference> spaceReferences, Consumer<XWikiDocument> migratedDocFixer, Consumer<XWikiDocument> migrationFixer) {
        int steps = (migrationReferences == null ? 0 : migrationReferences.size()) + (spaceReferences == null ? 0 : spaceReferences.size());
        if (steps == 0) {
            this.logger.warn("There is nothing to fix");
            return;
        }
        this.progressManager.pushLevelProgress(steps, (Object)this);
        this.fixDocumentsOfMigrations(s, migrationReferences, migrationFixer);
        this.fixDocumentsOfSpaces(spaceReferences, migratedDocFixer);
        this.progressManager.popLevelProgress((Object)this);
    }

    public void fixDocumentsInSpace(EntityReference spaceReference, Consumer<XWikiDocument> migratedDocFixer) {
        List docFullNames;
        String wiki;
        String spaceRef;
        EntityReference spaceRoot = spaceReference.getRoot();
        if (spaceRoot != null && spaceRoot.getType() == EntityType.WIKI) {
            spaceRef = (String)this.serializer.serialize(spaceReference, new Object[]{spaceRoot});
            wiki = spaceRoot.getName();
        } else {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            wiki = context.getWikiId();
            spaceRef = (String)this.serializer.serialize(spaceReference, new Object[]{context.getWikiReference()});
        }
        try {
            docFullNames = this.queryManager.createQuery("select doc.fullName from Document doc where doc.fullName like concat(:space, '.%')", "xwql").setWiki(wiki).bindValue("space", (Object)spaceRef).execute();
        }
        catch (QueryException e) {
            this.logger.error("Failed to list the documents in space [{}], skipping.", (Object)spaceRef, (Object)e);
            return;
        }
        List<String> docs = docFullNames.stream().map(fullName -> wiki + ":" + fullName).collect(Collectors.toList());
        this.fixDocuments(docs, migratedDocFixer);
    }

    public void fixDocuments(Collection<String> docRefs, Consumer<XWikiDocument> documentFixer) {
        if (CollectionUtils.isEmpty(docRefs)) {
            this.logger.warn("There are no documents to fix");
            return;
        }
        this.progressManager.pushLevelProgress(docRefs.size(), (Object)this);
        int size = docRefs.size();
        int n = 0;
        for (String migratedDocRefStr : docRefs) {
            this.progressManager.startStep((Object)this);
            EntityReference migratedDocRef = this.resolver.resolve((Object)migratedDocRefStr, EntityType.DOCUMENT, new Object[0]);
            this.logger.info("Handling document [{}] ({}/{})", new Object[]{migratedDocRef, ++n, size});
            XWikiDocument migratedDoc = this.getDocument(migratedDocRef);
            if (migratedDoc == null) continue;
            documentFixer.accept(migratedDoc);
            this.progressManager.endStep((Object)this);
        }
        this.progressManager.popLevelProgress((Object)this);
    }

    public void handleDocumentUpdate(MigrationFixingStats s, XWikiDocument migratedDoc, boolean updated, boolean updateInPlace, boolean dryRun, String revisionComment) {
        if (!updated) {
            this.logger.info(UNCHANGED_MARKER, "Document [{}] is left unchanged", (Object)migratedDoc.getDocumentReference());
            s.incUnchangedDocs();
            return;
        }
        DocumentReference migratedDocRef = migratedDoc.getDocumentReference();
        if (dryRun) {
            this.logger.info("Would update document [{}]", (Object)migratedDocRef);
            s.incSuccessfulDocs();
            return;
        }
        try {
            if (updateInPlace) {
                this.logger.info(UPDATED_MARKER, "Updating document [{}] without adding a revision", (Object)migratedDocRef);
                migratedDoc.setMetaDataDirty(false);
                migratedDoc.setContentDirty(false);
            } else {
                this.logger.info(UPDATED_MARKER, "Updating document [{}], adding a new revision", (Object)migratedDocRef);
            }
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            context.getWiki().saveDocument(migratedDoc, revisionComment, context);
            s.incSuccessfulDocs();
        }
        catch (XWikiException e) {
            this.logger.error("Failed to save document [{}]", (Object)migratedDocRef, (Object)e);
            s.incFailedDocs();
        }
    }

    public Map<String, Object> getInputProperties(XWikiDocument migrationDoc) {
        String inputPropertiesString = migrationDoc.getStringValue("inputProperties");
        if (StringUtils.isEmpty((CharSequence)inputPropertiesString)) {
            this.logger.warn("Failed to find input properties for migration [{}]", (Object)migrationDoc.getDocumentReference());
            return null;
        }
        try {
            return (Map)new ObjectMapper().readValue(inputPropertiesString, INPUT_PROPERTIES_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to read input properties for migration [{}]", (Object)migrationDoc.getDocumentReference(), (Object)e);
            return null;
        }
    }

    private EntityReference computeSpaceReference(String space, EntityNameValidation nameStrategy, boolean guess, EntityReference root) {
        String validatedSpace;
        EntityReference spaceReference = null;
        String string = validatedSpace = nameStrategy == null ? space : nameStrategy.transform(space);
        if (guess) {
            try {
                spaceReference = this.spaceKeyResolver.getSpaceByKey(space);
            }
            catch (ConfluenceResolverException e) {
                this.logger.error("Failed to resolve space [{}] using Confluence resolvers", (Object)space, (Object)e);
            }
        } else {
            spaceReference = new EntityReference(validatedSpace, EntityType.SPACE, root);
        }
        return spaceReference;
    }

    private EntityReference computeRootSpace(Map<String, Object> inputProperties, EntityReferenceResolver<String> resolver) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        String rootSpaceStr = (String)inputProperties.get("root");
        if (StringUtils.isEmpty((CharSequence)rootSpaceStr)) {
            rootSpaceStr = (String)inputProperties.get("rootSpace");
        }
        if (StringUtils.isEmpty((CharSequence)rootSpaceStr)) {
            return context.getWikiReference();
        }
        if (rootSpaceStr.startsWith("wiki:")) {
            return new WikiReference(rootSpaceStr.substring(5));
        }
        if (rootSpaceStr.startsWith("space:")) {
            return resolver.resolve((Object)rootSpaceStr.substring(6), EntityType.SPACE, new Object[0]);
        }
        if (rootSpaceStr.endsWith(".WebHome")) {
            rootSpaceStr = rootSpaceStr.substring(0, rootSpaceStr.length() - 8);
        }
        return resolver.resolve((Object)rootSpaceStr, EntityType.SPACE, new Object[0]);
    }

    private void fixDocumentsOfMigrations(MigrationFixingStats s, List<EntityReference> migrationReferences, Consumer<XWikiDocument> migrationFixer) {
        if (CollectionUtils.isEmpty(migrationReferences)) {
            this.logger.warn("There are no migrations to fix");
            return;
        }
        int size = migrationReferences.size();
        int n = 0;
        for (EntityReference migrationReference : migrationReferences) {
            this.progressManager.startStep((Object)this);
            this.logger.info("Browsing documents of migration [{}] ({}/{})", new Object[]{migrationReference, ++n, size});
            XWikiDocument doc = this.getDoc(s, migrationReference);
            if (doc != null) {
                migrationFixer.accept(doc);
            }
            this.progressManager.endStep((Object)this);
        }
    }

    private XWikiDocument getDoc(MigrationFixingStats s, EntityReference migrationReference) {
        XWikiDocument migrationDoc;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            migrationDoc = context.getWiki().getDocument(migrationReference, context);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get the migration document [{}], skipping.", (Object)migrationReference, (Object)e);
            s.incFailedDocs();
            return null;
        }
        if (migrationDoc.isNew()) {
            this.logger.warn("Failed to find migration document [{}], skipping", (Object)migrationReference);
            s.incFailedDocs();
            return null;
        }
        return migrationDoc;
    }

    private XWikiDocument getDocument(EntityReference migratedDocRef) {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiDocument migratedDoc = context.getWiki().getDocument(migratedDocRef, context).clone();
            if (migratedDoc == null || migratedDoc.isNew()) {
                this.logger.error("The migrated document [{}] doesn't exist, skipping.", (Object)migratedDocRef);
                return null;
            }
            return migratedDoc;
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get the migrated document [{}], skipping.", (Object)migratedDocRef, (Object)e);
            return null;
        }
    }
}

