/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.script;

import com.xwiki.admintools.configuration.AdminToolsConfiguration;
import com.xwiki.admintools.internal.AdminToolsManager;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.internal.network.NetworkManager;
import com.xwiki.admintools.internal.security.CheckSecurityCache;
import com.xwiki.admintools.internal.security.EntityRightsProvider;
import com.xwiki.admintools.internal.usage.wikiResult.WikiRecycleBins;
import com.xwiki.admintools.internal.usage.wikiResult.WikiSizeResult;
import com.xwiki.admintools.jobs.HealthCheckJobRequest;
import com.xwiki.admintools.security.RightsResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrDocumentList;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.stability.Unstable;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="admintools")
@Singleton
@Unstable
public class AdminToolsScriptService
implements ScriptService {
    @Inject
    @Named(value="default")
    protected AdminToolsConfiguration adminToolsConfig;
    @Inject
    private AdminToolsManager adminToolsManager;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private ModelContext modelContext;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private EntityRightsProvider entityRightsProvider;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private NetworkManager networkManager;
    @Inject
    private CheckSecurityCache checkSecurityCache;

    @Unstable
    public Map<String, Object> getJSONFromNetwork(String target, Map<String, String> parameters, boolean useRef) throws IOException, InterruptedException, AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.networkManager.getJSONFromNetwork(target, parameters, useRef);
    }

    @Unstable
    public Map<String, Object> getNetworkLimits() throws IOException, InterruptedException, AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.networkManager.getLimits();
    }

    @Unstable
    public String checkSecurityCache(DocumentReference userRef, DocumentReference docRef) throws AuthorizationException {
        return this.checkSecurityCache.displaySecurityCheck(userRef, docRef);
    }

    @Unstable
    public Map<String, String> extractRuleUsersGroups(SecurityRule rule) {
        return this.checkSecurityCache.extractRuleUsersGroups(rule);
    }

    @Unstable
    public List<RightsResult> getEntityRights(Map<String, String> filters, String sortColumn, String order, String entityType) {
        return this.entityRightsProvider.getEntityRights(filters, sortColumn, order, entityType);
    }

    @Unstable
    public String getConfigurationData() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.generateData();
    }

    @Unstable
    public List<WikiSizeResult> getWikisSize(Map<String, String> filters, String sortColumn, String order) throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getWikiSizeResults(filters, sortColumn, order);
    }

    @Unstable
    public String getConfigurationData(String hint) throws AccessDeniedException, ComponentLookupException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.generateData(hint);
    }

    @Unstable
    public List<String> getSupportedDatabases() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getSupportedDBs();
    }

    @Unstable
    public List<String> getSupportedServers() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getSupportedServers();
    }

    @Unstable
    public String getFilesSection() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getFilesSection();
    }

    @Unstable
    public String getInstanceSizeSection() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getInstanceSizeTemplate();
    }

    @Unstable
    public SolrDocumentList getPagesOverGivenNumberOfComments(long maxComments, Map<String, String> filters, String order) throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getPagesOverGivenNumberOfComments(maxComments, filters, order);
    }

    @Unstable
    public SolrDocumentList getEmptyDocuments(Map<String, String> filters, String order) throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getEmptyDocuments(filters, order);
    }

    @Unstable
    public int getMinimumSpamSize() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsConfig.getSpamSize();
    }

    @Unstable
    public Job runHealthChecks() throws Exception {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        List<String> requestId = this.getHealthCheckJobId();
        Job job = this.jobExecutor.getJob(requestId);
        if (job == null) {
            HealthCheckJobRequest healthCheckJobRequest = new HealthCheckJobRequest(requestId);
            return this.jobExecutor.execute("admintools.healthcheck", (Request)healthCheckJobRequest);
        }
        return job;
    }

    @Unstable
    public List<String> getHealthCheckJobId() throws AccessDeniedException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
        return List.of("adminTools", "healthCheck", currentWiki);
    }

    @Unstable
    public boolean isUsedServerCompatible() {
        return this.currentServer.getCurrentServer() != null;
    }

    @Unstable
    public List<WikiRecycleBins> getWikisRecycleBinSize(Map<String, String> filters, String sortColumn, String order) throws AccessDeniedException, WikiManagerException {
        this.contextualAuthorizationManager.checkAccess(Right.ADMIN);
        return this.adminToolsManager.getWikisRecycleBinsSize(filters, sortColumn, order);
    }
}

