/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage.wikiResult;

import com.xwiki.admintools.usage.WikiUsageResult;
import java.text.DecimalFormat;
import java.util.List;
import org.xwiki.stability.Unstable;

@Unstable
public class WikiSizeResult
implements WikiUsageResult {
    private String wikiName;
    private Long userCount;
    private Long attachmentsSize;
    private Long attachmentsCount;
    private Long documentsCount;

    public String getWikiName() {
        return this.wikiName;
    }

    public void setWikiName(String wikiName) {
        this.wikiName = wikiName;
    }

    public Long getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Long userCount) {
        this.userCount = userCount;
    }

    public Long getAttachmentsSize() {
        return this.attachmentsSize;
    }

    public void setAttachmentsSize(Long attachmentsSize) {
        this.attachmentsSize = attachmentsSize;
    }

    public Long getAttachmentsCount() {
        return this.attachmentsCount;
    }

    public void setAttachmentsCount(Long attachmentsCount) {
        this.attachmentsCount = attachmentsCount;
    }

    public Long getDocumentsCount() {
        return this.documentsCount;
    }

    public void setDocumentsCount(Long documentsCount) {
        this.documentsCount = documentsCount;
    }

    public String getReadableAttachmentSize() {
        if (this.attachmentsSize == null || this.attachmentsSize <= 0L) {
            return "0";
        }
        List<String> units = List.of("B", "KB", "MB", "GB");
        int digitGroup = (int)(Math.log10(this.attachmentsSize.longValue()) / Math.log10(1024.0));
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.#");
        String resultedSize = decimalFormat.format((double)this.attachmentsSize.longValue() / Math.pow(1024.0, digitGroup));
        return String.format("%s %s", resultedSize, units.get(digitGroup));
    }
}

