/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage.metadataExtractor;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.search.solr.SolrEntityMetadataExtractor;

@Component
@Named(value="spammed-doc")
@Singleton
public class SpamSolrEntityMetadataExtractor
implements SolrEntityMetadataExtractor<XWikiDocument> {
    private static final EntityReference COMMENTSCLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiComments");
    @Inject
    private Logger logger;

    public boolean extract(XWikiDocument entity, SolrInputDocument solrDocument) {
        try {
            List results = entity.getXObjects(COMMENTSCLASS_REFERENCE);
            solrDocument.setField("AdminTools.NumberOfComments_sortInt", (Object)results.size());
        }
        catch (Exception e) {
            this.logger.error("Failed to index the right for document [{}]", (Object)entity.getDocumentReference(), (Object)e);
        }
        return true;
    }
}

