/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage.metadataExtractor;

import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.search.solr.SolrEntityMetadataExtractor;

@Component
@Named(value="empty-doc")
@Singleton
public class EmptyPagesSolrEntityMetadataExtractor
implements SolrEntityMetadataExtractor<XWikiDocument> {
    @Inject
    private Logger logger;

    public boolean extract(XWikiDocument entity, SolrInputDocument solrDocument) {
        try {
            boolean isEmpty = entity.getXObjects().isEmpty() && entity.getAttachmentList().isEmpty() && entity.getContent().trim().isEmpty() && entity.getXClassXML().trim().isEmpty();
            solrDocument.setField("AdminTools.DocumentContentEmpty_boolean", (Object)isEmpty);
        }
        catch (Exception e) {
            this.logger.error("Failed to index the right for document [{}]", (Object)entity.getDocumentReference(), (Object)e);
        }
        return true;
    }
}

