/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.query.SecureQuery;
import org.xwiki.search.solr.SolrUtils;

@Component(roles={SpamPagesProvider.class})
@Singleton
public class SpamPagesProvider {
    private static final List<String> VALID_SORT_ORDERS = List.of("desc", "asc");
    @Inject
    @Named(value="secure")
    private QueryManager secureQueryManager;
    @Inject
    private SolrUtils solrUtils;

    public SolrDocumentList getDocumentsOverGivenNumberOfComments(long maxComments, Map<String, String> filters, String order) throws Exception {
        Query query;
        String searchedDocument = filters.get("docName");
        String queryStatement = "*";
        if (searchedDocument != null && !searchedDocument.isEmpty()) {
            queryStatement = String.format("title:%s", this.solrUtils.toCompleteFilterQueryString((Object)searchedDocument));
        }
        ArrayList<String> filterStatements = new ArrayList<String>();
        filterStatements.add("type:DOCUMENT");
        filterStatements.add(String.format("AdminTools.NumberOfComments_sortInt:[%d TO *]", maxComments));
        String searchedWiki = filters.get("wikiName");
        if (searchedWiki != null && !searchedWiki.isEmpty() && !searchedWiki.equals("-")) {
            String searchedWikiID = searchedWiki.replace("XWikiServer", "").toLowerCase();
            filterStatements.add(String.format("wiki:%s", this.solrUtils.toCompleteFilterQueryString((Object)searchedWikiID)));
        }
        if ((query = this.secureQueryManager.createQuery(queryStatement, "solr")) instanceof SecureQuery) {
            ((SecureQuery)query).checkCurrentAuthor(true);
            ((SecureQuery)query).checkCurrentUser(true);
        }
        query.bindValue("fl", (Object)"title_, reference, wiki, AdminTools.NumberOfComments_sortInt, name, spaces");
        query.bindValue("fq", filterStatements);
        query.bindValue("sort", (Object)String.format("AdminTools.NumberOfComments_sortInt %s", VALID_SORT_ORDERS.contains(order) ? order : VALID_SORT_ORDERS.get(0)));
        query.setLimit(100);
        return ((QueryResponse)query.execute().get(0)).getResults();
    }
}

