/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.usage;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xwiki.admintools.usage.WikiUsageResult;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

public abstract class AbstractInstanceUsageProvider {
    private static final String WIKI_NAME_KEY = "wikiName";
    private static final String DOCUMENTS_COUNT_KEY = "documentsCount";
    private static final String ATTACHMENTS_COUNT_KEY = "attachmentsCount";
    private static final String TOTAL_COUNT_KEY = "totalCount";
    private static final String USER_COUNT_KEY = "userCount";
    private static final String ATTACHMENTS_SIZE_KEY = "attachmentsSize";
    private static final String INTERVAL_SEPARATOR = "-";
    private static final String DESCENDING_ORDER = "desc";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;

    public boolean checkFilters(Map<String, String> filters, WikiUsageResult wikiData) {
        return filters.entrySet().stream().filter(filter -> filter.getValue() != null && !((String)filter.getValue()).isEmpty() && !((String)filter.getValue()).equals(INTERVAL_SEPARATOR)).allMatch(filter -> {
            switch ((String)filter.getKey()) {
                case "userCount": {
                    return wikiData.getUserCount().equals(Long.parseLong((String)filter.getValue()));
                }
                case "attachmentsSize": {
                    return this.checkAttachmentSize(wikiData, (String)filter.getValue());
                }
                case "attachmentsCount": {
                    return wikiData.getAttachmentsCount().equals(Long.parseLong((String)filter.getValue()));
                }
                case "documentsCount": {
                    return wikiData.getDocumentsCount().equals(Long.parseLong((String)filter.getValue()));
                }
                case "totalCount": {
                    return wikiData.getTotal().equals(Long.parseLong((String)filter.getValue()));
                }
            }
            throw new IllegalArgumentException("Invalid filter field: " + (String)filter.getKey());
        });
    }

    public void applySort(List<WikiUsageResult> list, String sortColumn, String order) {
        Comparator<WikiUsageResult> comparator = null;
        switch (sortColumn) {
            case "wikiName": {
                comparator = Comparator.comparing(WikiUsageResult::getWikiName);
                break;
            }
            case "userCount": {
                comparator = Comparator.comparing(WikiUsageResult::getUserCount);
                break;
            }
            case "attachmentsSize": {
                comparator = Comparator.comparing(WikiUsageResult::getAttachmentsSize);
                break;
            }
            case "attachmentsCount": {
                comparator = Comparator.comparing(WikiUsageResult::getAttachmentsCount);
                break;
            }
            case "documentsCount": {
                comparator = Comparator.comparing(WikiUsageResult::getDocumentsCount);
                break;
            }
            case "totalCount": {
                comparator = Comparator.comparing(WikiUsageResult::getTotal);
                break;
            }
        }
        if (comparator != null) {
            if (DESCENDING_ORDER.equals(order)) {
                comparator = comparator.reversed();
            }
            list.sort(comparator);
        }
    }

    public void applyDocumentsSort(List<DocumentReference> list, String sortColumn, String order) {
        XWikiContext xWikiContext = (XWikiContext)this.xcontextProvider.get();
        XWiki xWiki = xWikiContext.getWiki();
        Comparator<DocumentReference> comparator = null;
        switch (sortColumn) {
            case "wikiName": {
                comparator = Comparator.comparing(doc -> {
                    try {
                        return ((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getById(doc.getWikiReference().getName()).getPrettyName();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                break;
            }
            case "docName": {
                comparator = Comparator.comparing(doc -> {
                    try {
                        return xWiki.getDocument(doc, xWikiContext).getTitle();
                    }
                    catch (XWikiException e) {
                        throw new RuntimeException(e);
                    }
                });
                break;
            }
            case "commentsCount": {
                comparator = Comparator.comparing(doc -> {
                    try {
                        return xWiki.getDocument(doc, xWikiContext).getComments().size();
                    }
                    catch (XWikiException e) {
                        throw new RuntimeException(e);
                    }
                });
                break;
            }
        }
        if (comparator != null) {
            if (DESCENDING_ORDER.equals(order)) {
                comparator = comparator.reversed();
            }
            list.sort(comparator);
        }
    }

    public Collection<WikiDescriptor> getRequestedWikis(Map<String, String> filters) throws WikiManagerException {
        Collection wikisDescriptors = ((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getAll();
        String filteredName = filters.get(WIKI_NAME_KEY);
        if (filteredName != null && !filteredName.isEmpty()) {
            wikisDescriptors.removeIf(wiki -> !wiki.getPrettyName().toLowerCase().contains(filteredName.toLowerCase()));
            filters.remove(WIKI_NAME_KEY);
        }
        return wikisDescriptors;
    }

    private boolean checkAttachmentSize(WikiUsageResult wikiData, String filter) {
        String[] interval = filter.split(INTERVAL_SEPARATOR);
        long attachmentsSize = wikiData.getAttachmentsSize() == null ? 1L : wikiData.getAttachmentsSize();
        long lowerBound = Long.parseLong(interval[0]);
        long upperBound = "x".equals(interval[1]) ? Long.MAX_VALUE : Long.parseLong(interval[1]);
        return attachmentsSize > lowerBound && attachmentsSize < upperBound;
    }
}

