/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.uploadJob;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import com.xwiki.admintools.jobs.PackageUploadJobStatus;
import com.xwiki.admintools.uploadPackageJob.UploadPackageJobResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.stability.Unstable;

@Component(roles={UploadJobFileProcessor.class})
@Singleton
@Unstable
public class UploadJobFileProcessor {
    private static final String SEPARATOR_KEY = "_";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> attachmentReferenceResolver;
    @Inject
    private Environment environment;
    @Inject
    private CurrentServer currentServer;
    @Inject
    private Logger logger;

    public UploadPackageJobResource maybeBackupFile(String filePath, PackageUploadJobStatus status) {
        Path targetFolderPath = Paths.get(this.currentServer.getCurrentServer().getXWikiInstallFolderPath(), new String[0]);
        File targetFile = targetFolderPath.resolve(filePath).toFile();
        UploadPackageJobResource uploadPackageJobResource = new UploadPackageJobResource();
        String fileName = targetFile.getName();
        uploadPackageJobResource.setNewFilename(fileName);
        if (targetFile.exists()) {
            this.createBackupFile(targetFile, uploadPackageJobResource, status);
        } else {
            String extension;
            int extensionIndex = filePath.lastIndexOf(".");
            String string = extension = extensionIndex != -1 ? filePath.substring(extensionIndex) : "";
            if (extension.equals(".jar")) {
                String simpleFileName = this.extractNameBeforeVersion(fileName);
                File parentFile = new File(targetFile.getParent());
                String[] filesList = parentFile.list((dir, name) -> name.startsWith(simpleFileName) && name.endsWith(extension));
                if (filesList == null || filesList.length > 1) {
                    JobResult log = new JobResult("adminTools.jobs.upload.assessoriginal.fail", JobResultLevel.ERROR, new Object[]{fileName});
                    status.addLog(log);
                    throw new RuntimeException(String.format("Unable to correctly assess the original file for %s.", fileName));
                }
                if (filesList.length == 1) {
                    targetFile = parentFile.toPath().resolve(filesList[0]).toFile();
                    this.createBackupFile(targetFile, uploadPackageJobResource, status);
                }
            }
        }
        uploadPackageJobResource.setTargetFile(targetFile);
        return uploadPackageJobResource;
    }

    public InputStream getArchiveInputStream(String fileRef) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        AttachmentReference attachmentReference = this.attachmentReferenceResolver.resolve((Object)fileRef, new Object[0]);
        XWikiDocument parentDoc = xcontext.getWiki().getDocument(attachmentReference.getDocumentReference(), xcontext);
        return parentDoc.getAttachment(attachmentReference.getName()).getContentInputStream(xcontext);
    }

    public void processFileContent(ZipInputStream zis, UploadPackageJobResource jobResource, PackageUploadJobStatus status) throws IOException {
        File targetFile = jobResource.getTargetFile();
        try (FileOutputStream fos = new FileOutputStream(targetFile, false);){
            String filePath;
            File newFile;
            int len;
            byte[] buffer = new byte[8192];
            while ((len = zis.read(buffer)) > 0) {
                ((OutputStream)fos).write(buffer, 0, len);
            }
            if (!jobResource.getNewFilename().equals(targetFile.getName()) && !targetFile.renameTo(newFile = Paths.get(filePath = targetFile.getParent(), new String[0]).resolve(jobResource.getNewFilename()).toFile())) {
                status.addLog(new JobResult("adminTools.jobs.upload.save.fail", JobResultLevel.ERROR, new Object[]{targetFile.getName()}));
                throw new RuntimeException(String.format("Failed to rename original file [%s].", targetFile.getName()));
            }
            this.logger.info("Successfully uploaded file [{}].", (Object)jobResource.getNewFilename());
            JobResult log = new JobResult("adminTools.jobs.upload.save.success", JobResultLevel.INFO, new Object[]{jobResource.getNewFilename()});
            status.addLog(log);
        }
    }

    public void initializeBackupFolder(List<String> folderId) throws IOException {
        Path backupFilePath = this.getBackupFolderPath(folderId);
        Files.createDirectories(backupFilePath, new FileAttribute[0]);
    }

    private Path getBackupFolderPath(List<String> jobId) {
        String sanitizeJobId = jobId.stream().map(s -> s.replaceAll("\\p{Punct}", SEPARATOR_KEY)).collect(Collectors.joining(SEPARATOR_KEY));
        return this.environment.getPermanentDirectory().toPath().resolve("adminTools").resolve("backup").resolve(sanitizeJobId);
    }

    private void createBackupFile(File targetFile, UploadPackageJobResource uploadPackageJobResource, PackageUploadJobStatus status) {
        Path backupFilePath = this.getBackupFolderPath(status.getJobID());
        File backupFile = backupFilePath.resolve(targetFile.getName() + ".bak").toFile();
        try {
            Files.copy(targetFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            JobResult log = new JobResult("adminTools.jobs.upload.backup.fail", JobResultLevel.ERROR, new Object[]{backupFile.getName(), targetFile.getName()});
            status.addLog(log);
            throw new RuntimeException(e);
        }
        this.logger.info("Backup file [{}] created for file [{}].", (Object)backupFile.getName(), (Object)targetFile.getName());
        uploadPackageJobResource.setBackupFile(backupFile);
        status.addLog(new JobResult("adminTools.jobs.upload.backup.success", JobResultLevel.INFO, new Object[]{backupFile.getName(), targetFile.getName()}));
    }

    private String extractNameBeforeVersion(String input) {
        String regex = "^([\\w-]+(?:-[\\w-]+)*)(?=(-\\d+|\\.[^.]+$))";
        Matcher matcher = Pattern.compile(regex).matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return input;
    }
}

