/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.security;

import com.xpn.xwiki.XWikiContext;
import com.xwiki.admintools.security.RightsResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractRightsProvider {
    static final String SEPARATOR = "-";
    static final String TYPE_KEY = "type";
    static final String SPACE_KEY = "space";
    static final String DOCUMENT_KEY = "docName";
    static final String LEVEL_KEY = "level";
    static final String ENTITY_KEY = "entity";
    static final String POLICY_KEY = "policy";
    private static final String DESCENDING_ORDER = "desc";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;

    public boolean checkFilters(Map<String, String> filters, RightsResult wikiData) {
        return filters.entrySet().stream().filter(filter -> filter.getValue() != null && !((String)filter.getValue()).isEmpty() && !((String)filter.getValue()).equals(SEPARATOR)).allMatch(filter -> {
            switch ((String)filter.getKey()) {
                case "policy": {
                    return wikiData.getPolicy().equalsIgnoreCase((String)filter.getValue());
                }
                case "level": {
                    String[] levelArray = ((String)filter.getValue()).split("\\|");
                    return Arrays.stream(levelArray).filter(level -> !level.equals(SEPARATOR)).allMatch(wikiData.getLevel()::contains);
                }
            }
            return true;
        });
    }

    public List<RightsResult> applySort(Set<RightsResult> list, String sortColumn, String order) {
        Comparator<RightsResult> comparator = null;
        ArrayList<RightsResult> unsortedList = new ArrayList<RightsResult>(list);
        switch (sortColumn) {
            case "policy": {
                comparator = Comparator.comparing(RightsResult::getPolicy);
                break;
            }
            case "level": {
                comparator = Comparator.comparing(RightsResult::getLevel);
                break;
            }
            case "type": {
                comparator = Comparator.comparing(RightsResult::getType);
                break;
            }
            case "space": {
                comparator = Comparator.comparing(RightsResult::getSpace);
                break;
            }
            case "docName": {
                comparator = Comparator.comparing(RightsResult::getDocReference);
                break;
            }
            case "entity": {
                comparator = Comparator.comparing(RightsResult::getEntity);
                break;
            }
        }
        if (comparator != null) {
            if (DESCENDING_ORDER.equals(order)) {
                comparator = comparator.reversed();
            }
            unsortedList.sort(comparator);
        }
        return unsortedList;
    }
}

