/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.security;

import com.xwiki.admintools.internal.health.checks.security.AbstractSecurityHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="languageEncoding")
@Singleton
public class LangEncodingHealthCheck
extends AbstractSecurityHealthCheck {
    public static final String HINT = "languageEncoding";

    public JobResult check() {
        String langEnc = this.getSecurityProviderJSON().get("LANG");
        if (langEnc == null || !langEnc.contains(".")) {
            this.logger.info("Language encoding could not be detected.");
            return new JobResult("adminTools.dashboard.healthcheck.security.system.lang.notFound", JobResultLevel.INFO, new Object[0]);
        }
        boolean isSafeLangEnc = this.isSafeEncoding(langEnc.split("\\.")[1], "System language");
        if (!isSafeLangEnc) {
            return new JobResult("adminTools.dashboard.healthcheck.security.system.lang.warn", JobResultLevel.WARN, new Object[]{langEnc});
        }
        return new JobResult("adminTools.dashboard.healthcheck.security.system.lang.info", JobResultLevel.INFO, new Object[0]);
    }
}

