/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.security;

import com.xwiki.admintools.internal.health.checks.security.AbstractSecurityHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="fileEncoding")
@Singleton
public class FileEncodingHealthCheck
extends AbstractSecurityHealthCheck {
    public static final String HINT = "fileEncoding";

    public JobResult check() {
        String fileEnc = this.getSecurityProviderJSON().get(HINT);
        if (fileEnc == null) {
            this.logger.warn("File encoding could not be detected!");
            return new JobResult("adminTools.dashboard.healthcheck.security.system.file.notFound", JobResultLevel.WARN, new Object[0]);
        }
        boolean isSafeFileEnc = this.isSafeEncoding(fileEnc, "System file");
        if (!isSafeFileEnc) {
            return new JobResult("adminTools.dashboard.healthcheck.security.system.file.warn", JobResultLevel.WARN, new Object[]{fileEnc});
        }
        return new JobResult("adminTools.dashboard.healthcheck.security.system.file.info", JobResultLevel.INFO, new Object[0]);
    }
}

