/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.performance;

import com.xwiki.admintools.ServerInfo;
import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.internal.data.identifiers.CurrentServer;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="physicalSpace")
@Singleton
public class PhysicalSpaceHealthCheck
implements HealthCheck {
    public static final String HINT = "physicalSpace";
    @Inject
    private CurrentServer currentServer;
    @Inject
    private Logger logger;

    public JobResult check() {
        File diskPartition;
        ServerInfo server = this.currentServer.getCurrentServer();
        if (server == null) {
            diskPartition = System.getProperty("os.name").toLowerCase().contains("windows") ? new File("C:") : new File("/");
        } else {
            Path xwikiPath = Paths.get(server.getXwikiCfgFolderPath(), new String[0]);
            Path rootDrive = xwikiPath.getRoot();
            diskPartition = new File(String.valueOf(rootDrive));
        }
        long freePartitionSpace = diskPartition.getFreeSpace();
        float freeSpace = (float)freePartitionSpace / 1.0737418E9f;
        if (freeSpace > 16.0f) {
            return new JobResult("adminTools.dashboard.healthcheck.performance.space.info", JobResultLevel.INFO, new Object[0]);
        }
        this.logger.warn("There is not enough free space for the XWiki installation! Current free space is [{}]", (Object)Float.valueOf(freeSpace));
        return new JobResult("adminTools.dashboard.healthcheck.performance.space.warn", JobResultLevel.WARN, new Object[]{Float.valueOf(freeSpace), diskPartition.getAbsolutePath()});
    }
}

