/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.performance;

import com.xwiki.admintools.health.HealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

@Component
@Named(value="physicalMemory")
@Singleton
public class PhysicalMemoryHealthCheck
implements HealthCheck {
    public static final String HINT = "physicalMemory";
    @Inject
    private Logger logger;

    public JobResult check() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        float totalMemory = (float)hardware.getMemory().getTotal() / 1.0737418E9f;
        DecimalFormat format = new DecimalFormat("0.#");
        if (totalMemory > 2.0f) {
            return new JobResult("adminTools.dashboard.healthcheck.performance.memory.info", JobResultLevel.INFO, new Object[0]);
        }
        String systemCapacityMessage = format.format(totalMemory);
        this.logger.warn("There is not enough memory to safely run the XWiki installation! Physical memory detected: [{}]", (Object)systemCapacityMessage);
        return new JobResult("adminTools.dashboard.healthcheck.performance.memory.warn", JobResultLevel.WARN, new Object[]{systemCapacityMessage});
    }
}

