/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.admintools.internal.health.checks.configuration;

import com.xwiki.admintools.health.XWikiVersions;
import com.xwiki.admintools.internal.health.checks.configuration.AbstractConfigurationHealthCheck;
import com.xwiki.admintools.jobs.JobResult;
import com.xwiki.admintools.jobs.JobResultLevel;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.version.internal.DefaultVersion;

@Component
@Named(value="configurationJava")
@Singleton
public class ConfigurationJavaHealthCheck
extends AbstractConfigurationHealthCheck {
    public static final String HINT = "configurationJava";
    private static final String REGEX = "\\.";

    public JobResult check() {
        float javaVersion;
        Map<String, String> configurationJson = this.getConfigurationProviderJSON();
        String javaVersionString = configurationJson.get("javaVersion");
        if (javaVersionString == null) {
            this.logger.warn("Java version not found!");
            return new JobResult("adminTools.dashboard.healthcheck.java.warn", JobResultLevel.WARN, new Object[0]);
        }
        String xwikiVersionString = configurationJson.get("xwikiVersion");
        if (!this.isJavaXWikiCompatible(xwikiVersionString, javaVersion = this.parseJavaVersionFloat(javaVersionString))) {
            this.logger.error("Java version is not compatible with the current XWiki installation!");
            return new JobResult("adminTools.dashboard.healthcheck.java.error", JobResultLevel.ERROR, new Object[]{javaVersionString, xwikiVersionString});
        }
        return new JobResult("adminTools.dashboard.healthcheck.java.info", JobResultLevel.INFO, new Object[0]);
    }

    private float parseJavaVersionFloat(String javaVersionString) {
        String[] parts = javaVersionString.split(REGEX);
        return Float.parseFloat(parts[0] + "." + parts[1]);
    }

    private boolean isJavaXWikiCompatible(String xwikiVersion, float javaVersion) {
        boolean isCompatible = false;
        if (this.isInInterval(xwikiVersion, XWikiVersions.XWIKI_8_1.getVersion(), XWikiVersions.XWIKI_11_3.getVersion())) {
            isCompatible = javaVersion == 1.8f;
        } else if (this.isInInterval(xwikiVersion, XWikiVersions.XWIKI_11_3.getVersion(), XWikiVersions.XWIKI_14_0.getVersion())) {
            isCompatible = javaVersion == 1.8f || this.isJavaCompatible(javaVersion, 10.99f, 12.0f);
        } else if (this.isInInterval(xwikiVersion, XWikiVersions.XWIKI_14_0.getVersion(), XWikiVersions.XWIKI_14_10_9.getVersion())) {
            isCompatible = this.isJavaCompatible(javaVersion, 10.99f, 12.0f);
        } else if (this.isInInterval(xwikiVersion, XWikiVersions.XWIKI_14_10_9.getVersion(), XWikiVersions.XWIKI_15_3.getVersion())) {
            isCompatible = this.isJavaCompatible(javaVersion, 16.99f, 18.0f) || this.isJavaCompatible(javaVersion, 10.99f, 12.0f);
        } else if (this.isInInterval(xwikiVersion, XWikiVersions.XWIKI_15_3.getVersion(), XWikiVersions.XWIKI_16_0.getVersion())) {
            isCompatible = this.isJavaCompatible(javaVersion, 10.99f, 12.0f) || this.isJavaCompatible(javaVersion, 16.99f, 18.0f);
        } else if (this.isInInterval(xwikiVersion, XWikiVersions.XWIKI_16_0.getVersion(), XWikiVersions.XWIKI_17_0.getVersion())) {
            isCompatible = this.isJavaCompatible(javaVersion, 16.99f, 22.0f);
        }
        return isCompatible;
    }

    private boolean isJavaCompatible(float checkedValue, float lowerBound, float upperBound) {
        return checkedValue > lowerBound && checkedValue < upperBound;
    }

    private boolean isInInterval(String checkedValue, String lowerBound, String upperBound) {
        DefaultVersion checkedVersion = new DefaultVersion(checkedValue);
        DefaultVersion lowerBoundVersion = new DefaultVersion(lowerBound);
        DefaultVersion upperBoundVersion = new DefaultVersion(upperBound);
        return checkedVersion.compareTo((Object)lowerBoundVersion) >= 0 && checkedVersion.compareTo((Object)upperBoundVersion) < 0;
    }
}

